<?php $__env->startSection('title', 'Portfolio Items'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Portfolio Items</h1>
    <a href="<?php echo e(route('admin.portfolio-items.create')); ?>" class="btn btn-primary">
        <i class="fas fa-plus"></i> Add New Portfolio Item
    </a>
</div>

<div class="card">
    <div class="card-body">
        <?php if($portfolioItems->count() > 0): ?>
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Image</th>
                            <th>Title</th>
                            <th>Category</th>
                            <th>Status</th>
                            <th>Sort Order</th>
                            <th>Created</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $portfolioItems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php if($item->image): ?>
                                        <?php if(filter_var($item->image, FILTER_VALIDATE_URL)): ?>
                                            <img src="<?php echo e($item->image); ?>" alt="<?php echo e($item->title); ?>" class="img-thumbnail" style="max-width: 80px; max-height: 60px; object-fit: cover;">
                                        <?php else: ?>
                                            <img src="<?php echo e(asset('storage/' . $item->image)); ?>" alt="<?php echo e($item->title); ?>" class="img-thumbnail" style="max-width: 80px; max-height: 60px; object-fit: cover;">
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <div class="bg-light d-flex align-items-center justify-content-center" style="width: 80px; height: 60px;">
                                            <i class="fas fa-image text-muted"></i>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <strong><?php echo e($item->title); ?></strong>
                                    <?php if($item->description): ?>
                                        <br><small class="text-muted"><?php echo e(Str::limit($item->description, 50)); ?></small>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($item->category): ?>
                                        <span class="badge bg-secondary"><?php echo e($item->category); ?></span>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if($item->is_active): ?>
                                        <span class="badge bg-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Inactive</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($item->sort_order ?? 0); ?></td>
                                <td>
                                    <small class="text-muted">
                                        <?php echo e($item->created_at->format('M j, Y')); ?>

                                    </small>
                                </td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="<?php echo e(route('admin.portfolio-items.show', $item)); ?>" class="btn btn-outline-info" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.portfolio-items.edit', $item)); ?>" class="btn btn-outline-primary" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="<?php echo e(route('admin.portfolio-items.destroy', $item)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this portfolio item?')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-outline-danger" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center text-muted py-5">
                <i class="fas fa-th fa-3x mb-3"></i>
                <p class="h5">No portfolio items found</p>
                <p>Start by creating your first portfolio item to showcase your work.</p>
                <a href="<?php echo e(route('admin.portfolio-items.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Create First Portfolio Item
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php if($portfolioItems->count() > 0): ?>
    <div class="mt-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Portfolio Statistics</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-primary"><?php echo e($portfolioItems->count()); ?></h4>
                            <small class="text-muted">Total Items</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-success"><?php echo e($portfolioItems->where('is_active', true)->count()); ?></h4>
                            <small class="text-muted">Active Items</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-info"><?php echo e($portfolioItems->whereNotNull('category')->pluck('category')->unique()->count()); ?></h4>
                            <small class="text-muted">Categories</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-warning"><?php echo e($portfolioItems->whereNotNull('url')->count()); ?></h4>
                            <small class="text-muted">With Links</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/pinky/resources/views/admin/portfolio-items/index.blade.php ENDPATH**/ ?>