<?php $__env->startSection('title', 'About Sections'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">About Sections</h1>
    <a href="<?php echo e(route('admin.about-sections.create')); ?>" class="btn btn-primary">
        <i class="fas fa-plus"></i> Add New About Section
    </a>
</div>

<div class="card">
    <div class="card-body">
        <?php if($aboutSections->count() > 0): ?>
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Image</th>
                            <th>Title</th>
                            <th>Subtitle</th>
                            <th>Content Preview</th>
                            <th>Status</th>
                            <th>Sort Order</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $aboutSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td>
                                    <?php if($section->image): ?>
                                        <?php if(filter_var($section->image, FILTER_VALIDATE_URL)): ?>
                                            <img src="<?php echo e($section->image); ?>" alt="<?php echo e($section->title); ?>" class="img-thumbnail" style="max-width: 80px; max-height: 60px; object-fit: cover;">
                                        <?php else: ?>
                                            <img src="<?php echo e(asset('storage/' . $section->image)); ?>" alt="<?php echo e($section->title); ?>" class="img-thumbnail" style="max-width: 80px; max-height: 60px; object-fit: cover;">
                                        <?php endif; ?>
                                    <?php else: ?>
                                        <div class="bg-light d-flex align-items-center justify-content-center" style="width: 80px; height: 60px;">
                                            <i class="fas fa-user text-muted"></i>
                                        </div>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <strong><?php echo e($section->title); ?></strong>
                                </td>
                                <td>
                                    <?php if($section->subtitle): ?>
                                        <small class="text-muted"><?php echo e(Str::limit($section->subtitle, 30)); ?></small>
                                    <?php else: ?>
                                        <span class="text-muted">-</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <small class="text-muted"><?php echo e(Str::limit($section->content, 50)); ?></small>
                                </td>
                                <td>
                                    <?php if($section->is_active): ?>
                                        <span class="badge bg-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Inactive</span>
                                    <?php endif; ?>
                                </td>
                                <td><?php echo e($section->sort_order ?? 0); ?></td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="<?php echo e(route('admin.about-sections.show', $section)); ?>" class="btn btn-outline-info" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="<?php echo e(route('admin.about-sections.edit', $section)); ?>" class="btn btn-outline-primary" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="<?php echo e(route('admin.about-sections.destroy', $section)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this about section?')">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-outline-danger" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center text-muted py-5">
                <i class="fas fa-user fa-3x mb-3"></i>
                <p class="h5">No about sections found</p>
                <p>Start by creating your first about section to tell your story.</p>
                <a href="<?php echo e(route('admin.about-sections.create')); ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Create First About Section
                </a>
            </div>
        <?php endif; ?>
    </div>
</div>

<?php if($aboutSections->count() > 0): ?>
    <div class="mt-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">About Section Statistics</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-primary"><?php echo e($aboutSections->count()); ?></h4>
                            <small class="text-muted">Total Sections</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-success"><?php echo e($aboutSections->where('is_active', true)->count()); ?></h4>
                            <small class="text-muted">Active Sections</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-info"><?php echo e($aboutSections->whereNotNull('image')->count()); ?></h4>
                            <small class="text-muted">With Images</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-warning"><?php echo e($aboutSections->whereNotNull('subtitle')->count()); ?></h4>
                            <small class="text-muted">With Subtitles</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/pinky/resources/views/admin/about-sections/index.blade.php ENDPATH**/ ?>