@extends('layouts.frontend')

@section('title', $portfolioItem->title . ' - ' . ($siteSettings['site_title'] ?? 'My Portfolio'))

@section('content')
<!-- Modern Portfolio Single Banner -->
<div class="w3-display-container modern-banner" style="min-height:100vh">
    @if(isset($banners['portfolio']) && $banners['portfolio'])
        <div class="w3-display-container" style="background-image: url('{{ $banners['portfolio']->background_image }}'); background-size: cover; background-position: center; min-height: 100vh;">
            <div class="banner-floating-elements">
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
            </div>
            <div class="w3-display-middle banner-content">
                <h1 class="banner-title">{{ $portfolioItem->title }}</h1>
                @if($portfolioItem->category)
                    <p class="banner-subtitle">{{ $portfolioItem->category }}</p>
                @endif
                <p class="banner-description">{{ $portfolioItem->description ?? 'Explore the details and creative process behind this project' }}</p>
                <div class="banner-buttons">
                    @if($portfolioItem->url)
                        <a href="{{ $portfolioItem->url }}" target="_blank" class="banner-btn primary">
                            <i class="fa fa-external-link"></i>
                            View Live Project
                        </a>
                    @endif
                    <a href="{{ route('portfolio.index') }}" class="banner-btn secondary">
                        <i class="fa fa-arrow-left"></i>
                        Back to Portfolio
                    </a>
                </div>
            </div>
        </div>
    @else
        <div class="bgimg-2 w3-display-container">
            <div class="banner-floating-elements">
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
            </div>
            <div class="w3-display-middle banner-content">
                <h1 class="banner-title">{{ $portfolioItem->title }}</h1>
                @if($portfolioItem->category)
                    <p class="banner-subtitle">{{ $portfolioItem->category }}</p>
                @endif
                <p class="banner-description">{{ $portfolioItem->description ?? 'Explore the details and creative process behind this project' }}</p>
                <div class="banner-buttons">
                    @if($portfolioItem->url)
                        <a href="{{ $portfolioItem->url }}" target="_blank" class="banner-btn primary">
                            <i class="fa fa-external-link"></i>
                            View Live Project
                        </a>
                    @endif
                    <a href="{{ route('portfolio.index') }}" class="banner-btn secondary">
                        <i class="fa fa-arrow-left"></i>
                        Back to Portfolio
                    </a>
                </div>
            </div>
        </div>
    @endif
</div>

<!-- Modern Portfolio Item Details -->
<section class="modern-portfolio-detail-section">
    <div class="w3-container w3-padding-64">
        <div class="w3-content">
            <div class="portfolio-detail-layout">
                <!-- Image Section -->
                <div class="portfolio-detail-image">
                    <div class="detail-image-wrapper">
                        @if(filter_var($portfolioItem->image, FILTER_VALIDATE_URL))
                            <img src="{{ $portfolioItem->image }}" alt="{{ $portfolioItem->title }}" class="detail-image">
                        @else
                            <img src="{{ asset('storage/' . $portfolioItem->image) }}" alt="{{ $portfolioItem->title }}" class="detail-image">
                        @endif
                        <div class="detail-image-overlay">
                            <button onclick="openImageModal()" class="detail-zoom-btn">
                                <i class="fa fa-search-plus"></i>
                            </button>
                        </div>
                    </div>
                </div>
                
                <!-- Content Section -->
                <div class="portfolio-detail-content">
                    <div class="detail-content-inner">
                        <!-- Category Badge -->
                        @if($portfolioItem->category)
                            <div class="detail-category-badge">{{ $portfolioItem->category }}</div>
                        @endif
                        
                        <!-- Title -->
                        <h1 class="detail-title">{{ $portfolioItem->title }}</h1>
                        
                        <!-- Description -->
                        @if($portfolioItem->description)
                            <div class="detail-description">
                                <p>{{ $portfolioItem->description }}</p>
                            </div>
                        @endif
                        
                        <!-- Action Buttons -->
                        <div class="detail-actions">
                            @if($portfolioItem->url)
                                <a href="{{ $portfolioItem->url }}" target="_blank" class="detail-action-btn primary">
                                    <i class="fa fa-external-link"></i>
                                    <span>View Live Project</span>
                                </a>
                            @endif
                            
                            <a href="{{ route('portfolio.index') }}" class="detail-action-btn secondary">
                                <i class="fa fa-arrow-left"></i>
                                <span>Back to Portfolio</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Background Elements -->
    <div class="portfolio-detail-bg">
        <div class="detail-bg-shape detail-bg-shape-1"></div>
        <div class="detail-bg-shape detail-bg-shape-2"></div>
    </div>
</section>

<!-- Related Projects -->
@if($relatedItems->count() > 0)
    <div class="w3-light-grey w3-padding-64">
        <div class="w3-content w3-container">
            <h3 class="w3-center">Related Projects</h3>
            <p class="w3-center"><em>You might also like these projects</em></p>
            
            <div class="w3-row-padding w3-center w3-margin-top">
                @foreach($relatedItems as $item)
                    <div class="w3-col l4 m6 w3-margin-bottom">
                        <div class="w3-card w3-white" style="height: 320px; display: flex; flex-direction: column;">
                            @if(filter_var($item->image, FILTER_VALIDATE_URL))
                                <img src="{{ $item->image }}" alt="{{ $item->title }}" style="width:100%;height:200px;object-fit:cover;flex-shrink:0;">
                            @else
                                <img src="{{ asset('storage/' . $item->image) }}" alt="{{ $item->title }}" style="width:100%;height:200px;object-fit:cover;flex-shrink:0;">
                            @endif
                            <div class="w3-container" style="flex: 1; display: flex; flex-direction: column; padding: 16px;">
                                <h4 style="margin: 0 0 8px 0; font-size: 18px;">{{ $item->title }}</h4>
                                @if($item->category)
                                    <p class="w3-opacity" style="margin: 0 0 12px 0; font-size: 14px;">{{ $item->category }}</p>
                                @endif
                                <div style="margin-top: auto;">
                                    <a href="{{ route('portfolio.show', $item) }}" class="w3-button w3-light-grey w3-small">
                                        View Project
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
@endif

<!-- Back to Portfolio -->
<div class="w3-center w3-padding-32">
    <a href="{{ route('portfolio.index') }}" class="w3-button w3-black w3-padding-large">
        <i class="fa fa-th"></i> View All Portfolio
    </a>
</div>
@endsection
