@extends('layouts.admin')

@section('title', 'Edit Site Setting')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Edit Site Setting</h1>
    <a href="{{ route('admin.site-settings.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to List
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <form action="{{ route('admin.site-settings.update', $siteSetting) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="mb-3">
                        <label for="key" class="form-label">Key <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('key') is-invalid @enderror" 
                               id="key" name="key" value="{{ old('key', $siteSetting->key) }}" required>
                        @error('key')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Unique identifier for this setting (e.g., site_title, hero_background)</div>
                    </div>

                    <div class="mb-3">
                        <label for="group" class="form-label">Group <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('group') is-invalid @enderror" 
                               id="group" name="group" value="{{ old('group', $siteSetting->group) }}" required>
                        @error('group')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Group this setting belongs to (e.g., general, hero, about, portfolio, contact)</div>
                    </div>

                    <div class="mb-3">
                        <label for="type" class="form-label">Type <span class="text-danger">*</span></label>
                        <select class="form-select @error('type') is-invalid @enderror" id="type" name="type" required>
                            <option value="">Select Type</option>
                            <option value="text" {{ old('type', $siteSetting->type) === 'text' ? 'selected' : '' }}>Text</option>
                            <option value="textarea" {{ old('type', $siteSetting->type) === 'textarea' ? 'selected' : '' }}>Textarea</option>
                            <option value="image" {{ old('type', $siteSetting->type) === 'image' ? 'selected' : '' }}>Image URL</option>
                            <option value="boolean" {{ old('type', $siteSetting->type) === 'boolean' ? 'selected' : '' }}>Boolean</option>
                        </select>
                        @error('type')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="value" class="form-label">Value</label>
                        <div id="value-container">
                            @if($siteSetting->type === 'textarea')
                                <textarea class="form-control @error('value') is-invalid @enderror" 
                                          id="value" name="value" rows="4">{{ old('value', $siteSetting->value) }}</textarea>
                            @elseif($siteSetting->type === 'boolean')
                                <select class="form-select @error('value') is-invalid @enderror" id="value" name="value">
                                    <option value="0" {{ old('value', $siteSetting->value) === '0' ? 'selected' : '' }}>False</option>
                                    <option value="1" {{ old('value', $siteSetting->value) === '1' ? 'selected' : '' }}>True</option>
                                </select>
                            @else
                                <input type="text" class="form-control @error('value') is-invalid @enderror" 
                                       id="value" name="value" value="{{ old('value', $siteSetting->value) }}">
                            @endif
                        </div>
                        @error('value')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="sort_order" class="form-label">Sort Order</label>
                        <input type="number" class="form-control @error('sort_order') is-invalid @enderror" 
                               id="sort_order" name="sort_order" value="{{ old('sort_order', $siteSetting->sort_order) }}">
                        @error('sort_order')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Order in which this setting should appear</div>
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Update Setting
                        </button>
                        <a href="{{ route('admin.site-settings.index') }}" class="btn btn-secondary">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Current Value Preview</h5>
            </div>
            <div class="card-body">
                @if($siteSetting->type === 'image' && filter_var($siteSetting->value, FILTER_VALIDATE_URL))
                    <img src="{{ $siteSetting->value }}" alt="Current Image" class="img-fluid rounded">
                @else
                    <p class="text-muted mb-0">{{ $siteSetting->value ?: 'No value set' }}</p>
                @endif
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
document.getElementById('type').addEventListener('change', function() {
    const type = this.value;
    const valueContainer = document.getElementById('value-container');
    const currentValue = '{{ old("value", $siteSetting->value) }}';
    
    let html = '';
    
    if (type === 'textarea') {
        html = `<textarea class="form-control" id="value" name="value" rows="4">${currentValue}</textarea>`;
    } else if (type === 'boolean') {
        html = `<select class="form-select" id="value" name="value">
                    <option value="0" ${currentValue === '0' ? 'selected' : ''}>False</option>
                    <option value="1" ${currentValue === '1' ? 'selected' : ''}>True</option>
                </select>`;
    } else {
        html = `<input type="text" class="form-control" id="value" name="value" value="${currentValue}">`;
    }
    
    valueContainer.innerHTML = html;
});
</script>
@endsection
