@extends('layouts.admin')

@section('title', 'View Contact Message')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Contact Message</h1>
    <a href="{{ route('admin.contact-messages.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to Messages
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    Message from {{ $contactMessage->name }}
                    @if(!$contactMessage->is_read)
                        <span class="badge bg-warning">Unread</span>
                    @else
                        <span class="badge bg-success">Read</span>
                    @endif
                </h5>
                <div class="btn-group btn-group-sm" role="group">
                    <form action="{{ route('admin.contact-messages.toggle-read', $contactMessage) }}" method="POST" class="d-inline">
                        @csrf
                        <button type="submit" class="btn btn-outline-{{ $contactMessage->is_read ? 'warning' : 'success' }}">
                            <i class="fas fa-{{ $contactMessage->is_read ? 'envelope' : 'envelope-open' }}"></i>
                            Mark as {{ $contactMessage->is_read ? 'Unread' : 'Read' }}
                        </button>
                    </form>
                    <form action="{{ route('admin.contact-messages.destroy', $contactMessage) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this message?')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-outline-danger">
                            <i class="fas fa-trash"></i> Delete
                        </button>
                    </form>
                </div>
            </div>
            <div class="card-body">
                <div class="mb-4">
                    <h6 class="text-muted">Message Content:</h6>
                    <div class="border rounded p-3 bg-light">
                        {!! nl2br(e($contactMessage->message)) !!}
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <h6 class="text-muted">Contact Information:</h6>
                        <p><strong>Name:</strong> {{ $contactMessage->name }}</p>
                        <p><strong>Email:</strong> 
                            <a href="mailto:{{ $contactMessage->email }}">{{ $contactMessage->email }}</a>
                        </p>
                    </div>
                    <div class="col-md-6">
                        <h6 class="text-muted">Message Details:</h6>
                        <p><strong>Received:</strong> {{ $contactMessage->created_at->format('F j, Y \a\t g:i A') }}</p>
                        <p><strong>IP Address:</strong> {{ $contactMessage->ip_address ?? 'Not recorded' }}</p>
                        @if($contactMessage->is_read && $contactMessage->read_at)
                            <p><strong>Read At:</strong> {{ $contactMessage->read_at->format('F j, Y \a\t g:i A') }}</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Quick Actions</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="mailto:{{ $contactMessage->email }}?subject=Re: Your message&body=Hello {{ $contactMessage->name }},%0D%0A%0D%0AThank you for your message:%0D%0A%0D%0A{{ urlencode($contactMessage->message) }}%0D%0A%0D%0ABest regards," 
                       class="btn btn-primary">
                        <i class="fas fa-reply"></i> Reply via Email
                    </a>
                    
                    <button class="btn btn-info" onclick="copyToClipboard('{{ $contactMessage->email }}')">
                        <i class="fas fa-copy"></i> Copy Email Address
                    </button>
                    
                    <a href="{{ route('admin.contact-messages.index') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-list"></i> View All Messages
                    </a>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Message Statistics</h5>
            </div>
            <div class="card-body">
                <small class="text-muted">
                    <p><strong>Message Length:</strong> {{ strlen($contactMessage->message) }} characters</p>
                    <p><strong>Word Count:</strong> {{ str_word_count($contactMessage->message) }} words</p>
                    <p><strong>Time Since Received:</strong> {{ $contactMessage->created_at->diffForHumans() }}</p>
                </small>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
function copyToClipboard(text) {
    navigator.clipboard.writeText(text).then(function() {
        alert('Email address copied to clipboard!');
    }, function(err) {
        console.error('Could not copy text: ', err);
    });
}
</script>
@endsection
