@extends('layouts.admin')

@section('title', 'Banners')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Banners</h1>
    <a href="{{ route('admin.banners.create') }}" class="btn btn-primary">
        <i class="fas fa-plus"></i> Add New Banner
    </a>
</div>

<div class="card">
    <div class="card-body">
        @if($banners->count() > 0)
            <div class="row">
                @foreach($banners as $banner)
                    <div class="col-md-6 col-lg-4 mb-4">
                        <div class="card h-100">
                            <div class="position-relative">
                                @if(filter_var($banner->background_image, FILTER_VALIDATE_URL))
                                    <img src="{{ $banner->background_image }}" class="card-img-top" alt="{{ $banner->title }}" style="height: 200px; object-fit: cover;">
                                @else
                                    <img src="{{ asset('storage/' . $banner->background_image) }}" class="card-img-top" alt="{{ $banner->title }}" style="height: 200px; object-fit: cover;">
                                @endif
                                
                                <!-- Banner overlay preview -->
                                <div class="position-absolute top-0 start-0 w-100 h-100 d-flex align-items-center justify-content-center" style="background: rgba(0,0,0,0.4);">
                                    @if($banner->overlay_text)
                                        <div class="text-center" style="color: {{ $banner->text_color }};">
                                            <h5 class="mb-0">{{ $banner->overlay_text }}</h5>
                                        </div>
                                    @endif
                                </div>
                                
                                <!-- Position badge -->
                                <span class="position-absolute top-0 end-0 m-2 badge bg-{{ $banner->position === 'hero' ? 'primary' : ($banner->position === 'portfolio' ? 'info' : ($banner->position === 'contact' ? 'success' : 'secondary')) }}">
                                    {{ ucfirst($banner->position) }}
                                </span>
                                
                                <!-- Status badge -->
                                <span class="position-absolute top-0 start-0 m-2 badge bg-{{ $banner->is_active ? 'success' : 'danger' }}">
                                    {{ $banner->is_active ? 'Active' : 'Inactive' }}
                                </span>
                            </div>
                            
                            <div class="card-body">
                                <h5 class="card-title">{{ $banner->title }}</h5>
                                @if($banner->subtitle)
                                    <p class="card-text text-muted small">{{ $banner->subtitle }}</p>
                                @endif
                                
                                <div class="d-flex justify-content-between align-items-center mt-3">
                                    <small class="text-muted">Order: {{ $banner->sort_order }}</small>
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="{{ route('admin.banners.show', $banner) }}" class="btn btn-outline-info" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('admin.banners.edit', $banner) }}" class="btn btn-outline-primary" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('admin.banners.destroy', $banner) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this banner?')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-outline-danger" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        @else
            <div class="text-center text-muted py-5">
                <i class="fas fa-image fa-3x mb-3"></i>
                <p class="h5">No banners found</p>
                <p>Create your first banner to customize the parallax sections of your website.</p>
                <a href="{{ route('admin.banners.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Create First Banner
                </a>
            </div>
        @endif
    </div>
</div>

@if($banners->count() > 0)
    <div class="mt-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Banner Statistics</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-primary">{{ $banners->count() }}</h4>
                            <small class="text-muted">Total Banners</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-success">{{ $banners->where('is_active', true)->count() }}</h4>
                            <small class="text-muted">Active Banners</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-info">{{ $banners->whereNotNull('button_text')->count() }}</h4>
                            <small class="text-muted">With Buttons</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-warning">{{ $banners->groupBy('position')->count() }}</h4>
                            <small class="text-muted">Positions Used</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif
@endsection
