<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $__env->yieldContent('title', 'Admin Panel'); ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <style>
        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            width: 250px;
            background: #343a40;
            padding: 0;
            z-index: 1000;
            overflow-y: auto;
        }
        
        .sidebar .nav-link {
            color: #adb5bd;
            padding: 12px 20px;
            border-bottom: 1px solid #495057;
            transition: all 0.3s;
        }
        
        .sidebar .nav-link:hover,
        .sidebar .nav-link.active {
            background-color: #495057;
            color: #fff;
        }
        
        .sidebar .nav-link i {
            width: 20px;
            margin-right: 10px;
        }
        
        .main-content {
            margin-left: 250px;
            min-height: 100vh;
        }
        
        .top-bar {
            background: #fff;
            padding: 15px 30px;
            border-bottom: 1px solid #dee2e6;
            box-shadow: 0 2px 4px rgba(0,0,0,.1);
        }
        
        .sidebar-brand {
            padding: 20px;
            border-bottom: 1px solid #495057;
            background: #212529;
        }
        
        .sidebar-brand a {
            color: #fff;
            text-decoration: none;
            font-size: 1.2rem;
            font-weight: bold;
        }
        
        .content-section {
            background: #f8f9fa;
            min-height: calc(100vh - 80px);
        }
        
        .sidebar-section {
            padding: 15px 0;
            border-bottom: 1px solid #495057;
        }
        
        .sidebar-section:last-child {
            border-bottom: none;
        }
        
        .sidebar-section-title {
            color: #6c757d;
            font-size: 0.75rem;
            font-weight: 600;
            text-transform: uppercase;
            padding: 0 20px 10px;
            margin: 0;
        }
        
        .badge-notification {
            font-size: 0.7rem;
            padding: 2px 6px;
        }

        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
                transition: transform 0.3s;
            }
            .sidebar.show {
                transform: translateX(0);
            }
            .main-content {
                margin-left: 0;
            }
            .mobile-toggle {
                display: block !important;
            }
        }
    </style>
</head>
<body class="bg-light">
    <!-- Sidebar -->
    <div class="sidebar" id="sidebar">
        <div class="sidebar-brand">
            <a href="<?php echo e(route('admin.dashboard')); ?>">
                <i class="fas fa-cog"></i> CMS Admin
            </a>
        </div>
        
        <nav class="mt-3">
            <!-- Dashboard -->
            <div class="sidebar-section">
                <a class="nav-link <?php echo e(request()->routeIs('admin.dashboard') ? 'active' : ''); ?>" href="<?php echo e(route('admin.dashboard')); ?>">
                    <i class="fas fa-home"></i> Dashboard
                </a>
            </div>

            <!-- Content Management -->
            <div class="sidebar-section">
                <h6 class="sidebar-section-title">Content Management</h6>
                <a class="nav-link <?php echo e(request()->routeIs('admin.site-settings.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.site-settings.index')); ?>">
                    <i class="fas fa-cog"></i> Site Settings
                </a>
                <a class="nav-link <?php echo e(request()->routeIs('admin.about-sections.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.about-sections.index')); ?>">
                    <i class="fas fa-user"></i> About Sections
                </a>
                <a class="nav-link <?php echo e(request()->routeIs('admin.portfolio-items.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.portfolio-items.index')); ?>">
                    <i class="fas fa-th"></i> Portfolio Items
                </a>
                <a class="nav-link <?php echo e(request()->routeIs('admin.skills.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.skills.index')); ?>">
                    <i class="fas fa-star"></i> Skills
                </a>
                <a class="nav-link <?php echo e(request()->routeIs('admin.statistics.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.statistics.index')); ?>">
                    <i class="fas fa-chart-bar"></i> Statistics
                </a>
                <a class="nav-link <?php echo e(request()->routeIs('admin.contact-info.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.contact-info.index')); ?>">
                    <i class="fas fa-address-book"></i> Contact Info
                </a>
                <a class="nav-link <?php echo e(request()->routeIs('admin.banners.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.banners.index')); ?>">
                    <i class="fas fa-image"></i> Banners
                </a>
            </div>

            <!-- Messages -->
            <div class="sidebar-section">
                <a class="nav-link <?php echo e(request()->routeIs('admin.contact-messages.*') ? 'active' : ''); ?>" href="<?php echo e(route('admin.contact-messages.index')); ?>">
                    <i class="fas fa-envelope"></i> Messages
                    <?php if(App\Models\ContactMessage::unread()->count() > 0): ?>
                        <span class="badge bg-danger badge-notification ms-auto"><?php echo e(App\Models\ContactMessage::unread()->count()); ?></span>
                    <?php endif; ?>
                </a>
            </div>

            <!-- User Menu -->
            <div class="sidebar-section">
                <h6 class="sidebar-section-title">Account</h6>
                <a class="nav-link" href="<?php echo e(route('home')); ?>" target="_blank">
                    <i class="fas fa-external-link-alt"></i> View Site
                </a>
                <a class="nav-link" href="<?php echo e(route('profile.edit')); ?>">
                    <i class="fas fa-user-cog"></i> Profile Settings
                </a>
                <form method="POST" action="<?php echo e(route('logout')); ?>" class="d-inline">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="nav-link border-0 bg-transparent w-100 text-start">
                        <i class="fas fa-sign-out-alt"></i> Logout
                    </button>
                </form>
            </div>
        </nav>
    </div>

    <!-- Main Content -->
    <div class="main-content">
        <!-- Top Bar -->
        <div class="top-bar d-flex justify-content-between align-items-center">
            <div>
                <button class="btn btn-outline-secondary d-md-none mobile-toggle" onclick="toggleSidebar()" style="display: none;">
                    <i class="fas fa-bars"></i>
                </button>
                <h5 class="mb-0 d-inline-block ms-2"><?php echo e(Auth::user()->name); ?></h5>
            </div>
            <div class="d-flex align-items-center">
                <span class="text-muted me-3"><?php echo e(now()->format('l, F j, Y')); ?></span>
                <a href="<?php echo e(route('home')); ?>" target="_blank" class="btn btn-outline-primary btn-sm">
                    <i class="fas fa-external-link-alt"></i> View Site
                </a>
            </div>
        </div>

        <!-- Content Area -->
        <div class="content-section">
            <div class="container-fluid py-4">
        <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <?php echo e(session('success')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php if(session('error')): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <?php echo e(session('error')); ?>

                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <ul class="mb-0">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function toggleSidebar() {
            const sidebar = document.getElementById('sidebar');
            sidebar.classList.toggle('show');
        }
        
        // Close sidebar when clicking outside on mobile
        document.addEventListener('click', function(event) {
            const sidebar = document.getElementById('sidebar');
            const toggleBtn = document.querySelector('.mobile-toggle');
            
            if (window.innerWidth <= 768 && 
                !sidebar.contains(event.target) && 
                !toggleBtn.contains(event.target)) {
                sidebar.classList.remove('show');
            }
        });
    </script>
    <?php echo $__env->yieldContent('scripts'); ?>
</body>
</html>
<?php /**PATH /opt/lampp/htdocs/pinky/resources/views/layouts/admin.blade.php ENDPATH**/ ?>