<?php $__env->startSection('title', 'Create Skill'); ?>

<?php $__env->startSection('content'); ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Create Skill</h1>
    <a href="<?php echo e(route('admin.skills.index')); ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to Skills
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <form action="<?php echo e(route('admin.skills.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    
                    <div class="mb-3">
                        <label for="name" class="form-label">Skill Name <span class="text-danger">*</span></label>
                        <input type="text" class="form-control <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="name" name="name" value="<?php echo e(old('name')); ?>" required>
                        <?php $__errorArgs = ['name'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <div class="form-text">e.g., Photography, Web Design, Photoshop</div>
                    </div>

                    <div class="mb-3">
                        <label for="percentage" class="form-label">Proficiency Level <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <input type="range" class="form-range" id="percentage-range" min="0" max="100" value="<?php echo e(old('percentage', 75)); ?>" oninput="updatePercentage(this.value)">
                            <input type="number" class="form-control <?php $__errorArgs = ['percentage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="percentage" name="percentage" value="<?php echo e(old('percentage', 75)); ?>" min="0" max="100" required style="max-width: 100px;" oninput="updateRange(this.value)">
                            <span class="input-group-text">%</span>
                        </div>
                        <?php $__errorArgs = ['percentage'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <div class="form-text">Your proficiency level from 0% to 100%</div>
                    </div>

                    <div class="mb-3">
                        <label for="color" class="form-label">Progress Bar Color <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <input type="color" class="form-control form-control-color <?php $__errorArgs = ['color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                                   id="color" name="color" value="<?php echo e(old('color', '#007bff')); ?>" required style="max-width: 60px;">
                            <input type="text" class="form-control" id="color-hex" value="<?php echo e(old('color', '#007bff')); ?>" readonly>
                        </div>
                        <?php $__errorArgs = ['color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <div class="form-text">Choose a color for the progress bar</div>
                    </div>

                    <div class="mb-3">
                        <label for="sort_order" class="form-label">Sort Order</label>
                        <input type="number" class="form-control <?php $__errorArgs = ['sort_order'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                               id="sort_order" name="sort_order" value="<?php echo e(old('sort_order', 0)); ?>">
                        <?php $__errorArgs = ['sort_order'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <div class="invalid-feedback"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        <div class="form-text">Lower numbers appear first</div>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" <?php echo e(old('is_active', true) ? 'checked' : ''); ?>>
                            <label class="form-check-label" for="is_active">
                                Active (show on website)
                            </label>
                        </div>
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Create Skill
                        </button>
                        <a href="<?php echo e(route('admin.skills.index')); ?>" class="btn btn-secondary">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Skill Preview</h5>
            </div>
            <div class="card-body">
                <div id="skill-preview">
                    <p id="preview-name">Photography</p>
                    <div class="progress" style="height: 25px;">
                        <div class="progress-bar" role="progressbar" id="preview-bar" style="width: 75%; background-color: #007bff;">
                            <span id="preview-percentage">75%</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Proficiency Guide</h5>
            </div>
            <div class="card-body">
                <ul class="list-unstyled small">
                    <li><strong>0-25%:</strong> <span class="text-muted">Beginner</span></li>
                    <li><strong>26-50%:</strong> <span class="text-muted">Basic</span></li>
                    <li><strong>51-75%:</strong> <span class="text-muted">Intermediate</span></li>
                    <li><strong>76-90%:</strong> <span class="text-muted">Advanced</span></li>
                    <li><strong>91-100%:</strong> <span class="text-muted">Expert</span></li>
                </ul>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Color Presets</h5>
            </div>
            <div class="card-body">
                <div class="d-flex flex-wrap gap-2">
                    <button type="button" class="btn btn-sm" style="background-color: #007bff; width: 30px; height: 30px;" onclick="setColor('#007bff')"></button>
                    <button type="button" class="btn btn-sm" style="background-color: #28a745; width: 30px; height: 30px;" onclick="setColor('#28a745')"></button>
                    <button type="button" class="btn btn-sm" style="background-color: #ffc107; width: 30px; height: 30px;" onclick="setColor('#ffc107')"></button>
                    <button type="button" class="btn btn-sm" style="background-color: #dc3545; width: 30px; height: 30px;" onclick="setColor('#dc3545')"></button>
                    <button type="button" class="btn btn-sm" style="background-color: #6f42c1; width: 30px; height: 30px;" onclick="setColor('#6f42c1')"></button>
                    <button type="button" class="btn btn-sm" style="background-color: #fd7e14; width: 30px; height: 30px;" onclick="setColor('#fd7e14')"></button>
                </div>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
function updatePercentage(value) {
    document.getElementById('percentage').value = value;
    updatePreview();
}

function updateRange(value) {
    document.getElementById('percentage-range').value = value;
    updatePreview();
}

function updatePreview() {
    const name = document.getElementById('name').value || 'Skill Name';
    const percentage = document.getElementById('percentage').value;
    const color = document.getElementById('color').value;
    
    document.getElementById('preview-name').textContent = name;
    document.getElementById('preview-bar').style.width = percentage + '%';
    document.getElementById('preview-bar').style.backgroundColor = color;
    document.getElementById('preview-percentage').textContent = percentage + '%';
}

function setColor(color) {
    document.getElementById('color').value = color;
    document.getElementById('color-hex').value = color;
    updatePreview();
}

// Update color hex display when color picker changes
document.getElementById('color').addEventListener('change', function() {
    document.getElementById('color-hex').value = this.value;
    updatePreview();
});

// Update preview when name changes
document.getElementById('name').addEventListener('input', updatePreview);

// Initial preview update
updatePreview();
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/pinky/resources/views/admin/skills/create.blade.php ENDPATH**/ ?>