@extends('layouts.frontend')

@section('title', ($siteSettings['portfolio_title'] ?? 'Portfolio') . ' - ' . ($siteSettings['site_title'] ?? 'My Portfolio'))

@section('content')
<!-- Modern Portfolio Banner -->
<div class="w3-display-container modern-banner" style="min-height:100vh">
    @if(isset($banners['portfolio']) && $banners['portfolio'])
        <div class="w3-display-container" style="background-image: url('{{ $banners['portfolio']->background_image }}'); background-size: cover; background-position: center; min-height: 100vh;">
            <div class="banner-floating-elements">
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
            </div>
            <div class="w3-display-middle banner-content">
                <h1 class="banner-title">{{ $banners['portfolio']->overlay_text ?? $banners['portfolio']->title }}</h1>
                @if($banners['portfolio']->subtitle)
                    <p class="banner-subtitle">{{ $banners['portfolio']->subtitle }}</p>
                @endif
                <p class="banner-description">{{ $siteSettings['hero_description'] ?? 'Creating exceptional digital experiences through innovative design and cutting-edge technology' }}</p>
                <div class="banner-buttons">
                    @if($banners['portfolio']->button_text && $banners['portfolio']->button_url)
                        <a href="{{ $banners['portfolio']->button_url }}" class="banner-btn primary">
                            <i class="fa fa-rocket"></i>
                            {{ $banners['portfolio']->button_text }}
                        </a>
                    @else
                        <a href="#portfolio-grid" class="banner-btn primary">
                            <i class="fa fa-th"></i>
                            Browse Projects
                        </a>
                    @endif
                    <a href="{{ route('contact') }}" class="banner-btn secondary">
                        <i class="fa fa-envelope"></i>
                        Start a Project
                    </a>
                </div>
            </div>
        </div>
    @else
        <div class="bgimg-2 w3-display-container">
            <div class="banner-floating-elements">
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
            </div>
            <div class="w3-display-middle banner-content">
                <h1 class="banner-title">{{ $siteSettings['portfolio_title'] ?? 'MY PORTFOLIO' }}</h1>
                @if($siteSettings['portfolio_subtitle'])
                    <p class="banner-subtitle">{{ $siteSettings['portfolio_subtitle'] }}</p>
                @endif
                <p class="banner-description">{{ $siteSettings['hero_description'] ?? 'Creating exceptional digital experiences through innovative design and cutting-edge technology' }}</p>
                <div class="banner-buttons">
                    <a href="#portfolio-grid" class="banner-btn primary">
                        <i class="fa fa-th"></i>
                        Browse Projects
                    </a>
                    <a href="{{ route('contact') }}" class="banner-btn secondary">
                        <i class="fa fa-envelope"></i>
                        Start a Project
                    </a>
                </div>
            </div>
        </div>
    @endif
</div>

<!-- Modern Portfolio Section -->
<section class="modern-portfolio-section" id="portfolio-grid">
    <div class="w3-container w3-padding-64">
        <div class="w3-content">
            <!-- Section Header -->
            <div class="portfolio-header w3-center w3-margin-bottom">
                <h2 class="portfolio-section-title">{{ $siteSettings['portfolio_title'] ?? 'My Portfolio' }}</h2>
                <p class="portfolio-section-subtitle">{{ $siteSettings['portfolio_subtitle'] ?? 'Explore my creative work and innovative projects' }}</p>
                <div class="portfolio-title-divider"></div>
            </div>

            <!-- Modern Category Filter -->
            @if($categories->count() > 0)
                <div class="modern-filter-section w3-center w3-margin-bottom">
                    <div class="modern-filter-tabs">
                        <a href="{{ route('portfolio.index') }}" class="modern-filter-tab {{ !request('category') ? 'active' : '' }}">
                            <span>All Projects</span>
                        </a>
                        @foreach($categories as $category)
                            <a href="{{ route('portfolio.index', ['category' => $category]) }}" 
                               class="modern-filter-tab {{ request('category') === $category ? 'active' : '' }}">
                                <span>{{ $category }}</span>
                            </a>
                        @endforeach
                    </div>
                </div>
            @endif

            @if($portfolioItems->count() > 0)
                <!-- Modern Portfolio Grid -->
                <div class="modern-portfolio-grid">
                    @foreach($portfolioItems as $index => $item)
                        <div class="modern-portfolio-card" data-aos="fade-up" data-aos-delay="{{ $index * 100 }}">
                            <div class="portfolio-card-inner">
                                <!-- Image Container -->
                                <div class="portfolio-image-wrapper">
                                    @if(filter_var($item->image, FILTER_VALIDATE_URL))
                                        <img src="{{ $item->image }}" alt="{{ $item->title }}" class="portfolio-image" onclick="onClick(this)" data-title="{{ $item->title }}" data-description="{{ $item->description }}">
                                    @else
                                        <img src="{{ asset('storage/' . $item->image) }}" alt="{{ $item->title }}" class="portfolio-image" onclick="onClick(this)" data-title="{{ $item->title }}" data-description="{{ $item->description }}">
                                    @endif
                                    
                                    <!-- Overlay -->
                                    <div class="portfolio-overlay">
                                        <div class="portfolio-overlay-content">
                                            <h4 class="portfolio-overlay-title">{{ $item->title }}</h4>
                                            @if($item->category)
                                                <p class="portfolio-overlay-category">{{ $item->category }}</p>
                                            @endif
                                            <div class="portfolio-overlay-buttons">
                                                <button onclick="onClick(this.parentElement.parentElement.parentElement.querySelector('.portfolio-image'))" class="portfolio-btn portfolio-btn-view">
                                                    <i class="fa fa-search-plus"></i>
                                                </button>
                                                @if($item->url)
                                                    <a href="{{ $item->url }}" target="_blank" class="portfolio-btn portfolio-btn-link">
                                                        <i class="fa fa-external-link"></i>
                                                    </a>
                                                @endif
                                                <a href="{{ route('portfolio.show', $item) }}" class="portfolio-btn portfolio-btn-details">
                                                    <i class="fa fa-info"></i>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Content -->
                                <div class="portfolio-content">
                                    <div class="portfolio-meta">
                                        @if($item->category)
                                            <span class="portfolio-category-tag">{{ $item->category }}</span>
                                        @endif
                                    </div>
                                    <h4 class="portfolio-title">{{ $item->title }}</h4>
                                    @if($item->description)
                                        <p class="portfolio-description">{{ Str::limit($item->description, 80) }}</p>
                                    @endif
                                    
                                    <!-- Action Buttons -->
                                    <div class="portfolio-actions">
                                        <a href="{{ route('portfolio.show', $item) }}" class="portfolio-action-btn primary">
                                            <i class="fa fa-eye"></i>
                                            <span>View Details</span>
                                        </a>
                                        @if($item->url)
                                            <a href="{{ $item->url }}" target="_blank" class="portfolio-action-btn secondary">
                                                <i class="fa fa-external-link"></i>
                                                <span>Visit</span>
                                            </a>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>

                <!-- Modern Pagination -->
                @if($portfolioItems->hasPages())
                    <div class="modern-pagination w3-center">
                        <div class="pagination-wrapper">
                            {{-- Previous Page Link --}}
                            @if($portfolioItems->onFirstPage())
                                <span class="pagination-btn disabled">
                                    <i class="fa fa-chevron-left"></i>
                                </span>
                            @else
                                <a href="{{ $portfolioItems->previousPageUrl() }}" class="pagination-btn">
                                    <i class="fa fa-chevron-left"></i>
                                </a>
                            @endif

                            {{-- Pagination Elements --}}
                            @foreach($portfolioItems->getUrlRange(1, $portfolioItems->lastPage()) as $page => $url)
                                @if($page == $portfolioItems->currentPage())
                                    <span class="pagination-btn active">{{ $page }}</span>
                                @else
                                    <a href="{{ $url }}" class="pagination-btn">{{ $page }}</a>
                                @endif
                            @endforeach

                            {{-- Next Page Link --}}
                            @if($portfolioItems->hasMorePages())
                                <a href="{{ $portfolioItems->nextPageUrl() }}" class="pagination-btn">
                                    <i class="fa fa-chevron-right"></i>
                                </a>
                            @else
                                <span class="pagination-btn disabled">
                                    <i class="fa fa-chevron-right"></i>
                                </span>
                            @endif
                        </div>
                        
                        <p class="pagination-info">
                            Showing {{ $portfolioItems->firstItem() }} to {{ $portfolioItems->lastItem() }} of {{ $portfolioItems->total() }} projects
                        </p>
                    </div>
                @endif
            @else
                <!-- Empty State -->
                <div class="portfolio-empty-state w3-center">
                    <div class="empty-state-icon">
                        <i class="fa fa-folder-open"></i>
                    </div>
                    <h3 class="empty-state-title">No Projects Found</h3>
                    <p class="empty-state-description">
                        @if(request('category'))
                            No projects found in the "{{ request('category') }}" category.
                        @else
                            No portfolio items are currently available.
                        @endif
                    </p>
                    @if(request('category'))
                        <a href="{{ route('portfolio.index') }}" class="modern-view-all-btn">
                            <span class="btn-text">View All Projects</span>
                            <i class="fa fa-arrow-left btn-arrow"></i>
                        </a>
                    @endif
                </div>
            @endif

            <!-- Back to Home -->
            <div class="portfolio-navigation w3-center">
                <a href="{{ route('home') }}" class="modern-view-all-btn">
                    <i class="fa fa-home btn-arrow"></i>
                    <span class="btn-text">Back to Home</span>
                </a>
            </div>
        </div>
    </div>
    
    <!-- Background Elements -->
    <div class="portfolio-bg-elements">
        <div class="portfolio-bg-shape portfolio-bg-shape-1"></div>
        <div class="portfolio-bg-shape portfolio-bg-shape-2"></div>
    </div>
</section>

<!-- Enhanced Modal for full size images -->
<div id="modal01" class="modern-modal" onclick="this.style.display='none'">
    <div class="modern-modal-backdrop"></div>
    <div class="modern-modal-content">
        <button class="modern-modal-close" title="Close Modal">
            <i class="fa fa-times"></i>
        </button>
        <div class="modern-modal-inner">
            <img id="img01" class="modern-modal-image">
            <div id="caption" class="modern-modal-caption"></div>
        </div>
    </div>
</div>

<script>
// Enhanced Modal Image Gallery
function onClick(element) {
    var modal = document.getElementById("modal01");
    var modalImg = document.getElementById("img01");
    var captionText = document.getElementById("caption");
    
    modalImg.src = element.src;
    captionText.innerHTML = element.alt || element.getAttribute('data-title') || '';
    
    modal.style.display = "block";
    
    // Add smooth fade-in animation
    modal.style.opacity = "0";
    setTimeout(function() {
        modal.style.opacity = "1";
    }, 10);
}

// Enhanced modal close
document.addEventListener('DOMContentLoaded', function() {
    var modal = document.getElementById("modal01");
    if (modal) {
        modal.addEventListener('click', function() {
            this.style.opacity = "0";
            setTimeout(function() {
                modal.style.display = "none";
            }, 300);
        });
    }
});
</script>
@endsection
