@extends('layouts.frontend')

@section('title', ($siteSettings['contact_title'] ?? 'Contact Me') . ' - ' . ($siteSettings['site_title'] ?? 'My Portfolio'))

@section('content')
<!-- Modern Contact Banner -->
<div class="w3-display-container modern-banner" style="min-height:100vh">
    @if(isset($banners['contact']) && $banners['contact'])
        <div class="w3-display-container" style="background-image: url('{{ $banners['contact']->background_image }}'); background-size: cover; background-position: center; min-height: 100vh;">
            <div class="banner-floating-elements">
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
            </div>
            <div class="w3-display-middle banner-content">
                <h1 class="banner-title">{{ $banners['contact']->overlay_text ?? $banners['contact']->title }}</h1>
                @if($banners['contact']->subtitle)
                    <p class="banner-subtitle">{{ $banners['contact']->subtitle }}</p>
                @endif
                <p class="banner-description">{{ $siteSettings['hero_description'] ?? 'Creating exceptional digital experiences through innovative design and cutting-edge technology' }}</p>
                <div class="banner-buttons">
                    @if($banners['contact']->button_text && $banners['contact']->button_url)
                        <a href="{{ $banners['contact']->button_url }}" class="banner-btn primary">
                            <i class="fa fa-rocket"></i>
                            {{ $banners['contact']->button_text }}
                        </a>
                    @else
                        <a href="#contact-form" class="banner-btn primary">
                            <i class="fa fa-envelope"></i>
                            Send Message
                        </a>
                    @endif
                    <a href="{{ route('portfolio.index') }}" class="banner-btn secondary">
                        <i class="fa fa-th"></i>
                        View Portfolio
                    </a>
                </div>
            </div>
        </div>
    @else
        <div class="bgimg-3 w3-display-container">
            <div class="banner-floating-elements">
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
            </div>
            <div class="w3-display-middle banner-content">
                <h1 class="banner-title">{{ $siteSettings['contact_title'] ?? 'CONTACT ME' }}</h1>
                @if($siteSettings['contact_subtitle'])
                    <p class="banner-subtitle">{{ $siteSettings['contact_subtitle'] }}</p>
                @else
                    <p class="banner-subtitle">Let's Connect & Create</p>
                @endif
                <p class="banner-description">{{ $siteSettings['hero_description'] ?? 'Creating exceptional digital experiences through innovative design and cutting-edge technology' }}</p>
                <div class="banner-buttons">
                    <a href="#contact-form" class="banner-btn primary">
                        <i class="fa fa-envelope"></i>
                        Send Message
                    </a>
                    <a href="{{ route('portfolio.index') }}" class="banner-btn secondary">
                        <i class="fa fa-th"></i>
                        View Portfolio
                    </a>
                </div>
            </div>
        </div>
    @endif
</div>

<!-- Modern Contact Information Cards -->
@if($contactInfo->whereIn('type', ['address', 'phone', 'email', 'website'])->count() > 0)
    <section class="modern-contact-section">
        <div class="w3-container w3-padding-64">
            <div class="w3-content">
                <!-- Section Header -->
                <div class="contact-header w3-center w3-margin-bottom">
                    <h2 class="section-title">{{ $siteSettings['contact_info_title'] ?? 'Get In Touch' }}</h2>
                    <p class="section-subtitle">{{ $siteSettings['contact_info_subtitle'] ?? 'Feel free to reach out through any of these channels' }}</p>
                    <div class="title-divider"></div>
                </div>

                <!-- Contact Cards Row -->
                <div class="contact-cards-row w3-margin-bottom">
                    @foreach($contactInfo->whereIn('type', ['address', 'phone', 'email', 'website']) as $contact)
                        <div class="modern-contact-card">
                            <div class="contact-card-icon">
                                <i class="fa {{ $contact->icon ?? 'fa-info' }}"></i>
                            </div>
                            <h4 class="contact-card-title">{{ $contact->label }}</h4>
                            <div class="contact-card-content">
                                <div class="contact-info">
                                    @if($contact->type === 'email')
                                        <a href="mailto:{{ $contact->value }}" class="contact-link">{{ $contact->value }}</a>
                                    @elseif($contact->type === 'phone')
                                        <a href="tel:{{ $contact->value }}" class="contact-link">{{ $contact->value }}</a>
                                    @elseif($contact->type === 'website')
                                        <p>{{ $contact->value }}</p>
                                    @else
                                        <p>{!! nl2br(e($contact->value)) !!}</p>
                                    @endif
                                </div>
                                @if(in_array($contact->type, ['email', 'phone', 'website']))
                                    <div class="contact-card-action">
                                        @if($contact->type === 'email')
                                            <a href="mailto:{{ $contact->value }}" class="contact-action-btn">
                                                <i class="fa fa-envelope"></i> Send Email
                                            </a>
                                        @elseif($contact->type === 'phone')
                                            <a href="tel:{{ $contact->value }}" class="contact-action-btn">
                                                <i class="fa fa-phone"></i> Call Now
                                            </a>
                                        @elseif($contact->type === 'website')
                                            <a href="{{ $contact->value }}" target="_blank" class="contact-action-btn">
                                                <i class="fa fa-globe"></i> Visit Website
                                            </a>
                                        @endif
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>
@endif

<!-- Modern Contact Form Section -->
<section class="modern-contact-section" id="contact-form">
    <div class="w3-container w3-padding-64">
        <div class="w3-content">
            <!-- Section Header -->
            <div class="contact-header w3-center w3-margin-bottom">
                <h2 class="section-title">{{ $siteSettings['contact_form_title'] ?? 'Send Message' }}</h2>
                <p class="section-subtitle">{{ $siteSettings['contact_form_description'] ?? 'Ready to start your next project? Let\'s create something amazing together.' }}</p>
                <div class="title-divider"></div>
            </div>

            <!-- Contact Form -->
            <div class="modern-contact-form-section">
                <div class="modern-contact-form">
                    <!-- Success/Error Messages -->
                    @if(session('success'))
                        <div class="alert alert-success">
                            <i class="fa fa-check-circle"></i>
                            <span>{{ session('success') }}</span>
                        </div>
                    @endif

                    @if($errors->any())
                        <div class="alert alert-error">
                            <i class="fa fa-exclamation-triangle"></i>
                            <ul>
                                @foreach($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('contact.store') }}" method="POST" class="contact-form">
                        @csrf
                        <div class="form-group-row">
                            <div class="form-group">
                                <input type="text" name="name" value="{{ old('name') }}" required 
                                       class="modern-input @error('name') error @enderror" 
                                       placeholder=" ">
                                <label class="modern-label">Full Name *</label>
                                <div class="input-border"></div>
                            </div>
                            <div class="form-group">
                                <input type="email" name="email" value="{{ old('email') }}" required 
                                       class="modern-input @error('email') error @enderror" 
                                       placeholder=" ">
                                <label class="modern-label">Email Address *</label>
                                <div class="input-border"></div>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <input type="text" name="subject" value="{{ old('subject') }}" 
                                   class="modern-input" placeholder=" ">
                            <label class="modern-label">Subject</label>
                            <div class="input-border"></div>
                        </div>
                        
                        <div class="form-group">
                            <textarea name="message" rows="6" required 
                                      class="modern-input modern-textarea @error('message') error @enderror" 
                                      placeholder=" ">{{ old('message') }}</textarea>
                            <label class="modern-label">Your Message *</label>
                            <div class="input-border"></div>
                        </div>
                        
                        <button type="submit" class="modern-submit-btn">
                            <span class="btn-text">Send Message</span>
                            <i class="fa fa-paper-plane btn-icon"></i>
                            <div class="btn-ripple"></div>
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Modern Business Hours & Additional Info -->
@if($contactInfo->where('type', 'other')->count() > 0)
    <section class="modern-info-section">
        <div class="w3-container w3-padding-64">
            <div class="w3-content">
                <!-- Section Header -->
                <div class="contact-header w3-center w3-margin-bottom">
                    <h2 class="section-title">{{ $siteSettings['business_info_title'] ?? 'Business Information' }}</h2>
                    <div class="title-divider"></div>
                </div>
                
                <div class="info-cards-grid">
                    @foreach($contactInfo->where('type', 'other') as $info)
                        <div class="modern-info-card">
                            <div class="info-card-icon">
                                <i class="fa {{ $info->icon ?? 'fa-info-circle' }}"></i>
                            </div>
                            <h4 class="info-card-title">{{ $info->label }}</h4>
                            <div class="info-card-content">
                                <p>{!! nl2br(e($info->value)) !!}</p>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </section>
@endif

<!-- Modern Social Media Section -->
@if($contactInfo->where('type', 'social')->count() > 0)
    <section class="modern-social-section">
        <div class="w3-container w3-padding-64">
            <div class="w3-content">
                <!-- Section Header -->
                <div class="social-header w3-center w3-margin-bottom">
                    <h2 class="social-section-title">{{ $siteSettings['social_title'] ?? 'Let\'s Connect' }}</h2>
                    <p class="social-section-subtitle">{{ $siteSettings['social_description'] ?? 'Follow me on social media for updates and behind-the-scenes content' }}</p>
                    <div class="social-title-divider"></div>
                </div>
                
                <div class="social-connect-section w3-center">
                    <div class="modern-social-links">
                        @foreach($contactInfo->where('type', 'social') as $social)
                            @if($social->is_active && filter_var($social->value, FILTER_VALIDATE_URL))
                                <a href="{{ $social->value }}" target="_blank" class="modern-social-btn" title="{{ $social->label }}">
                                    <i class="fa {{ $social->icon ?? 'fa-share-alt' }}"></i>
                                    <span class="social-label">{{ $social->label }}</span>
                                </a>
                            @endif
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Background Elements -->
        <div class="social-bg-elements">
            <div class="social-bg-circle social-bg-circle-1"></div>
            <div class="social-bg-circle social-bg-circle-2"></div>
        </div>
    </section>
@endif

<!-- Modern Location Section -->
@php $address = $contactInfo->where('type', 'address')->first(); @endphp
@if($address)
    <section class="modern-location-section">
        <div class="w3-container w3-padding-64">
            <div class="w3-content">
                <!-- Section Header -->
                <div class="location-header w3-center w3-margin-bottom">
                    <h2 class="location-section-title">{{ $siteSettings['location_title'] ?? 'Find Me Here' }}</h2>
                    <p class="location-section-subtitle">{{ $siteSettings['location_description'] ?? 'Visit me at my location or schedule an appointment' }}</p>
                    <div class="location-title-divider"></div>
                </div>
                
                <div class="location-layout">
                    <!-- Location Info Card -->
                    <div class="modern-location-card" data-aos="fade-right">
                        <div class="location-card-header">
                            <div class="location-icon">
                                <i class="fa {{ $address->icon ?? 'fa-map-marker' }}"></i>
                            </div>
                            <h3 class="location-title">{{ $address->label }}</h3>
                        </div>
                        <div class="location-address">
                            <p>{!! nl2br(e($address->value)) !!}</p>
                        </div>
                        
                        <!-- Quick Contact -->
                        <div class="location-quick-contact">
                            @php
                                $phone = $contactInfo->where('type', 'phone')->first();
                                $email = $contactInfo->where('type', 'email')->first();
                            @endphp
                            
                            @if($phone)
                                <div class="quick-contact-item">
                                    <i class="fa {{ $phone->icon ?? 'fa-phone' }}"></i>
                                    <a href="tel:{{ $phone->value }}">{{ $phone->value }}</a>
                                </div>
                            @endif
                            
                            @if($email)
                                <div class="quick-contact-item">
                                    <i class="fa {{ $email->icon ?? 'fa-envelope' }}"></i>
                                    <a href="mailto:{{ $email->value }}">{{ $email->value }}</a>
                                </div>
                            @endif
                        </div>
                    </div>
                    
                    <!-- Map Card -->
                    <div class="modern-map-card" data-aos="fade-left">
                        <div class="map-placeholder">
                            <div class="map-icon">
                                <i class="fa fa-map"></i>
                            </div>
                            <h4 class="map-title">Interactive Map</h4>
                            <p class="map-description">Click below to view location on Google Maps</p>
                            <a href="https://maps.google.com/?q={{ urlencode($address->value) }}" target="_blank" class="map-action-btn">
                                <i class="fa fa-map-marker"></i>
                                <span>View on Google Maps</span>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Background Elements -->
        <div class="location-bg-elements">
            <div class="location-bg-shape location-bg-shape-1"></div>
            <div class="location-bg-shape location-bg-shape-2"></div>
        </div>
    </section>
@endif

<!-- Modern Call to Action -->
<section class="modern-cta-section">
    <div class="w3-container w3-padding-64">
        <div class="w3-content">
            <div class="cta-content w3-center">
                <h2 class="cta-title">{{ $siteSettings['contact_cta_title'] ?? 'Let\'s Start a Conversation' }}</h2>
                <p class="cta-subtitle">{{ $siteSettings['contact_cta_description'] ?? 'Whether you have a project in mind or just want to say hello, I\'d love to hear from you.' }}</p>
                <div class="cta-actions">
                    <a href="#contact-form" class="cta-btn primary">
                        <i class="fa fa-envelope"></i>
                        <span>Send Message</span>
                    </a>
                    <a href="{{ route('portfolio.index') }}" class="cta-btn secondary">
                        <i class="fa fa-th"></i>
                        <span>View Portfolio</span>
                    </a>
                </div>
            </div>
        </div>
        
        <!-- Background Elements -->
        <div class="cta-bg-elements">
            <div class="cta-bg-shape cta-bg-shape-1"></div>
            <div class="cta-bg-shape cta-bg-shape-2"></div>
        </div>
    </section>
@endsection
