@extends('layouts.admin')

@section('title', 'Statistics')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Statistics</h1>
    <a href="{{ route('admin.statistics.create') }}" class="btn btn-primary">
        <i class="fas fa-plus"></i> Add New Statistic
    </a>
</div>

<div class="card">
    <div class="card-body">
        @if($statistics->count() > 0)
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Preview</th>
                            <th>Label</th>
                            <th>Value</th>
                            <th>Suffix</th>
                            <th>Icon</th>
                            <th>Status</th>
                            <th>Sort Order</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($statistics as $statistic)
                            <tr>
                                <td>
                                    <div class="text-center p-2 bg-dark text-white rounded" style="min-width: 100px;">
                                        @if($statistic->icon)
                                            <i class="{{ $statistic->icon }} mb-1"></i><br>
                                        @endif
                                        <span class="h6">{{ $statistic->value }}{{ $statistic->suffix }}</span><br>
                                        <small>{{ $statistic->label }}</small>
                                    </div>
                                </td>
                                <td>
                                    <strong>{{ $statistic->label }}</strong>
                                </td>
                                <td>
                                    <span class="badge bg-primary">{{ $statistic->value }}</span>
                                </td>
                                <td>
                                    @if($statistic->suffix)
                                        <code>{{ $statistic->suffix }}</code>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    @if($statistic->icon)
                                        <i class="{{ $statistic->icon }}"></i> <code>{{ $statistic->icon }}</code>
                                    @else
                                        <span class="text-muted">No icon</span>
                                    @endif
                                </td>
                                <td>
                                    @if($statistic->is_active)
                                        <span class="badge bg-success">Active</span>
                                    @else
                                        <span class="badge bg-danger">Inactive</span>
                                    @endif
                                </td>
                                <td>{{ $statistic->sort_order ?? 0 }}</td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="{{ route('admin.statistics.show', $statistic) }}" class="btn btn-outline-info" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('admin.statistics.edit', $statistic) }}" class="btn btn-outline-primary" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('admin.statistics.destroy', $statistic) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this statistic?')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-outline-danger" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="text-center text-muted py-5">
                <i class="fas fa-chart-bar fa-3x mb-3"></i>
                <p class="h5">No statistics found</p>
                <p>Start by adding your first statistic to showcase your achievements.</p>
                <a href="{{ route('admin.statistics.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Add First Statistic
                </a>
            </div>
        @endif
    </div>
</div>

@if($statistics->count() > 0)
    <div class="mt-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Statistics Preview</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    @foreach($statistics->where('is_active', true)->take(4) as $stat)
                        <div class="col-md-3 text-center mb-3">
                            <div class="p-3 bg-dark text-white rounded">
                                @if($stat->icon)
                                    <i class="{{ $stat->icon }} fa-2x mb-2"></i><br>
                                @endif
                                <span class="h4">{{ $stat->value }}{{ $stat->suffix }}</span><br>
                                <small>{{ $stat->label }}</small>
                            </div>
                        </div>
                    @endforeach
                </div>
                @if($statistics->where('is_active', true)->count() > 4)
                    <p class="text-center text-muted">
                        <small>Showing first 4 active statistics. Total: {{ $statistics->where('is_active', true)->count() }}</small>
                    </p>
                @endif
            </div>
        </div>
    </div>
@endif
@endsection
