@extends('layouts.admin')

@section('title', 'Edit Statistic')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Edit Statistic</h1>
    <a href="{{ route('admin.statistics.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to Statistics
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <form action="{{ route('admin.statistics.update', $statistic) }}" method="POST">
                    @csrf
                    @method('PUT')
                    
                    <div class="mb-3">
                        <label for="label" class="form-label">Label <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('label') is-invalid @enderror" 
                               id="label" name="label" value="{{ old('label', $statistic->label) }}" required>
                        @error('label')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">e.g., Happy Clients, Projects Completed, Years Experience</div>
                    </div>

                    <div class="row">
                        <div class="col-md-8">
                            <div class="mb-3">
                                <label for="value" class="form-label">Value <span class="text-danger">*</span></label>
                                <input type="text" class="form-control @error('value') is-invalid @enderror" 
                                       id="value" name="value" value="{{ old('value', $statistic->value) }}" required>
                                @error('value')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">The number or text to display (e.g., 150, 5K, 99.9)</div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="mb-3">
                                <label for="suffix" class="form-label">Suffix</label>
                                <input type="text" class="form-control @error('suffix') is-invalid @enderror" 
                                       id="suffix" name="suffix" value="{{ old('suffix', $statistic->suffix) }}" maxlength="10">
                                @error('suffix')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">e.g., +, %, K, M</div>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="icon" class="form-label">Icon Class</label>
                        <input type="text" class="form-control @error('icon') is-invalid @enderror" 
                               id="icon" name="icon" value="{{ old('icon', $statistic->icon) }}">
                        @error('icon')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">FontAwesome icon class (e.g., fas fa-users, fas fa-chart-line, fas fa-trophy)</div>
                    </div>

                    <div class="mb-3">
                        <label for="sort_order" class="form-label">Sort Order</label>
                        <input type="number" class="form-control @error('sort_order') is-invalid @enderror" 
                               id="sort_order" name="sort_order" value="{{ old('sort_order', $statistic->sort_order) }}">
                        @error('sort_order')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Lower numbers appear first</div>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', $statistic->is_active) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_active">
                                Active (show on website)
                            </label>
                        </div>
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Update Statistic
                        </button>
                        <a href="{{ route('admin.statistics.index') }}" class="btn btn-secondary">Cancel</a>
                        <a href="{{ route('admin.statistics.show', $statistic) }}" class="btn btn-info">
                            <i class="fas fa-eye"></i> View
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Current Statistic</h5>
            </div>
            <div class="card-body">
                <div id="current-preview" class="text-center mb-3">
                    <div class="p-3 bg-dark text-white rounded">
                        @if($statistic->icon)
                            <i class="{{ $statistic->icon }} fa-2x mb-2"></i><br>
                        @endif
                        <span class="h4">{{ $statistic->value }}{{ $statistic->suffix }}</span><br>
                        <small>{{ $statistic->label }}</small>
                    </div>
                </div>
                
                <hr>
                
                <div id="statistic-preview" class="text-center">
                    <h6>Live Preview:</h6>
                    <div class="p-3 bg-dark text-white rounded">
                        <i id="preview-icon" class="{{ $statistic->icon ?? 'fas fa-chart-bar' }} fa-2x mb-2"></i><br>
                        <span class="h4" id="preview-display">{{ $statistic->value }}{{ $statistic->suffix }}</span><br>
                        <small id="preview-label">{{ $statistic->label }}</small>
                    </div>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Statistic Details</h5>
            </div>
            <div class="card-body">
                <p><strong>Created:</strong> {{ $statistic->created_at->format('F j, Y \a\t g:i A') }}</p>
                <p><strong>Updated:</strong> {{ $statistic->updated_at->format('F j, Y \a\t g:i A') }}</p>
                <p><strong>Status:</strong> 
                    @if($statistic->is_active)
                        <span class="badge bg-success">Active</span>
                    @else
                        <span class="badge bg-danger">Inactive</span>
                    @endif
                </p>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Common Icons</h5>
            </div>
            <div class="card-body">
                <div class="row text-center">
                    <div class="col-4 mb-2">
                        <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="setIcon('fas fa-users')">
                            <i class="fas fa-users"></i><br><small>Users</small>
                        </button>
                    </div>
                    <div class="col-4 mb-2">
                        <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="setIcon('fas fa-chart-line')">
                            <i class="fas fa-chart-line"></i><br><small>Growth</small>
                        </button>
                    </div>
                    <div class="col-4 mb-2">
                        <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="setIcon('fas fa-trophy')">
                            <i class="fas fa-trophy"></i><br><small>Trophy</small>
                        </button>
                    </div>
                    <div class="col-4 mb-2">
                        <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="setIcon('fas fa-heart')">
                            <i class="fas fa-heart"></i><br><small>Heart</small>
                        </button>
                    </div>
                    <div class="col-4 mb-2">
                        <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="setIcon('fas fa-star')">
                            <i class="fas fa-star"></i><br><small>Star</small>
                        </button>
                    </div>
                    <div class="col-4 mb-2">
                        <button type="button" class="btn btn-outline-secondary btn-sm w-100" onclick="setIcon('fas fa-handshake')">
                            <i class="fas fa-handshake"></i><br><small>Partners</small>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
function updatePreview() {
    const label = document.getElementById('label').value || 'Statistic Label';
    const value = document.getElementById('value').value || '0';
    const suffix = document.getElementById('suffix').value || '';
    const icon = document.getElementById('icon').value || 'fas fa-chart-bar';
    
    document.getElementById('preview-label').textContent = label;
    document.getElementById('preview-display').textContent = value + suffix;
    document.getElementById('preview-icon').className = icon + ' fa-2x mb-2';
}

function setIcon(iconClass) {
    document.getElementById('icon').value = iconClass;
    updatePreview();
}

// Update preview when inputs change
document.getElementById('label').addEventListener('input', updatePreview);
document.getElementById('value').addEventListener('input', updatePreview);
document.getElementById('suffix').addEventListener('input', updatePreview);
document.getElementById('icon').addEventListener('input', updatePreview);

// Initial preview update
updatePreview();
</script>
@endsection
