@extends('layouts.admin')

@section('title', 'Create Portfolio Item')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Create Portfolio Item</h1>
    <a href="{{ route('admin.portfolio-items.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to Portfolio
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <form action="{{ route('admin.portfolio-items.store') }}" method="POST">
                    @csrf
                    
                    <div class="mb-3">
                        <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('title') is-invalid @enderror" 
                               id="title" name="title" value="{{ old('title') }}" required>
                        @error('title')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control @error('description') is-invalid @enderror" 
                                  id="description" name="description" rows="4">{{ old('description') }}</textarea>
                        @error('description')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Brief description of this portfolio item</div>
                    </div>

                    <div class="mb-3">
                        <label for="image" class="form-label">Image URL <span class="text-danger">*</span></label>
                        <input type="url" class="form-control @error('image') is-invalid @enderror" 
                               id="image" name="image" value="{{ old('image') }}" required>
                        @error('image')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Enter the full URL of the image (e.g., https://example.com/image.jpg)</div>
                    </div>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="category" class="form-label">Category</label>
                                <input type="text" class="form-control @error('category') is-invalid @enderror" 
                                       id="category" name="category" value="{{ old('category') }}">
                                @error('category')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">e.g., Web Design, Photography, Graphics</div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="sort_order" class="form-label">Sort Order</label>
                                <input type="number" class="form-control @error('sort_order') is-invalid @enderror" 
                                       id="sort_order" name="sort_order" value="{{ old('sort_order', 0) }}">
                                @error('sort_order')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Lower numbers appear first</div>
                            </div>
                        </div>
                    </div>

                    <div class="mb-3">
                        <label for="url" class="form-label">External URL</label>
                        <input type="url" class="form-control @error('url') is-invalid @enderror" 
                               id="url" name="url" value="{{ old('url') }}">
                        @error('url')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Optional link to the full project or external site</div>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_active">
                                Active (show on website)
                            </label>
                        </div>
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Create Portfolio Item
                        </button>
                        <a href="{{ route('admin.portfolio-items.index') }}" class="btn btn-secondary">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Image Preview</h5>
            </div>
            <div class="card-body">
                <div id="image-preview" class="text-center">
                    <div class="bg-light d-flex align-items-center justify-content-center" style="height: 200px;">
                        <i class="fas fa-image fa-3x text-muted"></i>
                    </div>
                    <small class="text-muted">Enter an image URL above to see preview</small>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Tips</h5>
            </div>
            <div class="card-body">
                <ul class="list-unstyled small">
                    <li><i class="fas fa-lightbulb text-warning"></i> Use high-quality images for better presentation</li>
                    <li><i class="fas fa-lightbulb text-warning"></i> Recommended image size: 800x600 pixels</li>
                    <li><i class="fas fa-lightbulb text-warning"></i> Use categories to organize your work</li>
                    <li><i class="fas fa-lightbulb text-warning"></i> Sort order determines display sequence</li>
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.getElementById('image').addEventListener('input', function() {
    const imageUrl = this.value;
    const previewDiv = document.getElementById('image-preview');
    
    if (imageUrl && isValidUrl(imageUrl)) {
        previewDiv.innerHTML = `
            <img src="${imageUrl}" alt="Preview" class="img-fluid rounded" style="max-height: 200px;" 
                 onerror="this.parentElement.innerHTML='<div class=\\'bg-danger text-white p-3 rounded\\'>Invalid image URL</div>'">
        `;
    } else {
        previewDiv.innerHTML = `
            <div class="bg-light d-flex align-items-center justify-content-center" style="height: 200px;">
                <i class="fas fa-image fa-3x text-muted"></i>
            </div>
            <small class="text-muted">Enter an image URL above to see preview</small>
        `;
    }
});

function isValidUrl(string) {
    try {
        new URL(string);
        return true;
    } catch (_) {
        return false;
    }
}
</script>
@endsection
