@extends('layouts.admin')

@section('title', 'Admin Dashboard')

@section('content')
<div class="row">
    <div class="col-12">
        <h1 class="h3 mb-4">Dashboard</h1>
    </div>
</div>

<!-- Content Management Cards -->
<div class="row">
    <div class="col-md-4 mb-4">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4 class="card-title">{{ $stats['site_settings'] }}</h4>
                        <p class="card-text">Site Settings</p>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-cog fa-2x"></i>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <a href="{{ route('admin.site-settings.index') }}" class="text-white text-decoration-none">
                    <small>Manage Settings <i class="fas fa-arrow-circle-right"></i></small>
                </a>
            </div>
        </div>
    </div>

    <div class="col-md-4 mb-4">
        <div class="card text-white bg-success">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4 class="card-title">{{ $stats['about_sections'] }}</h4>
                        <p class="card-text">About Sections</p>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-user fa-2x"></i>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <a href="{{ route('admin.about-sections.index') }}" class="text-white text-decoration-none">
                    <small>Manage About <i class="fas fa-arrow-circle-right"></i></small>
                </a>
            </div>
        </div>
    </div>

    <div class="col-md-4 mb-4">
        <div class="card text-white bg-warning">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4 class="card-title">{{ $stats['portfolio_items'] }}</h4>
                        <p class="card-text">Portfolio Items</p>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-th fa-2x"></i>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <a href="{{ route('admin.portfolio-items.index') }}" class="text-white text-decoration-none">
                    <small>Manage Portfolio <i class="fas fa-arrow-circle-right"></i></small>
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Skills & Statistics Row -->
<div class="row">
    <div class="col-md-4 mb-4">
        <div class="card text-white bg-info">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4 class="card-title">{{ $stats['skills'] }}</h4>
                        <p class="card-text">Skills</p>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-star fa-2x"></i>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <a href="{{ route('admin.skills.index') }}" class="text-white text-decoration-none">
                    <small>Manage Skills <i class="fas fa-arrow-circle-right"></i></small>
                </a>
            </div>
        </div>
    </div>

    <div class="col-md-4 mb-4">
        <div class="card text-white bg-secondary">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4 class="card-title">{{ $stats['statistics'] }}</h4>
                        <p class="card-text">Statistics</p>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-chart-bar fa-2x"></i>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <a href="{{ route('admin.statistics.index') }}" class="text-white text-decoration-none">
                    <small>Manage Statistics <i class="fas fa-arrow-circle-right"></i></small>
                </a>
            </div>
        </div>
    </div>

    <div class="col-md-4 mb-4">
        <div class="card text-white bg-dark">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4 class="card-title">{{ $stats['contact_info'] }}</h4>
                        <p class="card-text">Contact Info</p>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-address-book fa-2x"></i>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <a href="{{ route('admin.contact-info.index') }}" class="text-white text-decoration-none">
                    <small>Manage Contact <i class="fas fa-arrow-circle-right"></i></small>
                </a>
            </div>
        </div>
    </div>
</div>

<!-- Messages & Banners Row -->
<div class="row">
    <div class="col-md-4 mb-4">
        <div class="card text-white bg-primary">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4 class="card-title">{{ $stats['contact_messages'] }}</h4>
                        <p class="card-text">Total Messages</p>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-envelope fa-2x"></i>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <a href="{{ route('admin.contact-messages.index') }}" class="text-white text-decoration-none">
                    <small>View All Messages <i class="fas fa-arrow-circle-right"></i></small>
                </a>
            </div>
        </div>
    </div>

    <div class="col-md-4 mb-4">
        <div class="card text-white bg-{{ $stats['unread_messages'] > 0 ? 'warning' : 'success' }}">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4 class="card-title">{{ $stats['unread_messages'] }}</h4>
                        <p class="card-text">Unread Messages</p>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-envelope-open fa-2x"></i>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <a href="{{ route('admin.contact-messages.index', ['status' => 'unread']) }}" class="text-white text-decoration-none">
                    <small>View Unread <i class="fas fa-arrow-circle-right"></i></small>
                </a>
            </div>
        </div>
    </div>

    <div class="col-md-4 mb-4">
        <div class="card text-white bg-dark">
            <div class="card-body">
                <div class="d-flex justify-content-between">
                    <div>
                        <h4 class="card-title">{{ $stats['banners'] ?? 0 }}</h4>
                        <p class="card-text">Banners</p>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-image fa-2x"></i>
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <a href="{{ route('admin.banners.index') }}" class="text-white text-decoration-none">
                    <small>Manage Banners <i class="fas fa-arrow-circle-right"></i></small>
                </a>
            </div>
        </div>
    </div>
</div>

<div class="row mt-4">
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Quick Actions</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6 mb-3">
                        <a href="{{ route('admin.site-settings.create') }}" class="btn btn-primary btn-lg w-100">
                            <i class="fas fa-plus"></i> Add Site Setting
                        </a>
                    </div>
                    <div class="col-md-6 mb-3">
                        <a href="{{ route('admin.about-sections.create') }}" class="btn btn-success btn-lg w-100">
                            <i class="fas fa-plus"></i> Add About Section
                        </a>
                    </div>
                    <div class="col-md-6 mb-3">
                        <a href="{{ route('admin.portfolio-items.create') }}" class="btn btn-warning btn-lg w-100">
                            <i class="fas fa-plus"></i> Add Portfolio Item
                        </a>
                    </div>
                    <div class="col-md-6 mb-3">
                        <a href="{{ route('admin.skills.create') }}" class="btn btn-info btn-lg w-100">
                            <i class="fas fa-plus"></i> Add Skill
                        </a>
                    </div>
                    <div class="col-md-6 mb-3">
                        <a href="{{ route('admin.statistics.create') }}" class="btn btn-secondary btn-lg w-100">
                            <i class="fas fa-plus"></i> Add Statistic
                        </a>
                    </div>
                    <div class="col-md-6 mb-3">
                        <a href="{{ route('admin.banners.create') }}" class="btn btn-dark btn-lg w-100">
                            <i class="fas fa-plus"></i> Add Banner
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">System Info</h5>
            </div>
            <div class="card-body">
                <p><strong>Laravel Version:</strong> {{ app()->version() }}</p>
                <p><strong>PHP Version:</strong> {{ phpversion() }}</p>
                <p><strong>Environment:</strong> {{ app()->environment() }}</p>
                <p><strong>Admin User:</strong> {{ Auth::user()->name }}</p>
                <p><strong>Last Login:</strong> {{ Auth::user()->updated_at->diffForHumans() }}</p>
                <hr>
                <div class="d-grid gap-2">
                    <a href="{{ route('home') }}" target="_blank" class="btn btn-outline-primary">
                        <i class="fas fa-external-link-alt"></i> View Frontend
                    </a>
                    <a href="{{ route('profile.edit') }}" class="btn btn-outline-secondary">
                        <i class="fas fa-user-cog"></i> Profile Settings
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
