@extends('layouts.admin')

@section('title', 'View Contact Information')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Contact Information Details</h1>
    <div class="btn-group" role="group">
        <a href="{{ route('admin.contact-info.index') }}" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Back to Contact Info
        </a>
        <a href="{{ route('admin.contact-info.edit', $contactInfo) }}" class="btn btn-primary">
            <i class="fas fa-edit"></i> Edit
        </a>
    </div>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <div class="text-center mb-4">
                    @if($contactInfo->icon)
                        <i class="{{ $contactInfo->icon }} fa-4x text-primary mb-3"></i>
                    @else
                        <i class="fas fa-info-circle fa-4x text-muted mb-3"></i>
                    @endif
                    <h2>{{ $contactInfo->label }}</h2>
                    <span class="badge bg-{{ $contactInfo->type === 'email' ? 'primary' : ($contactInfo->type === 'phone' ? 'success' : ($contactInfo->type === 'address' ? 'info' : 'secondary')) }} fs-6">
                        {{ ucfirst($contactInfo->type) }}
                    </span>
                </div>

                <div class="mb-4">
                    <h5>Contact Information</h5>
                    <div class="border rounded p-4 bg-light">
                        @if($contactInfo->type === 'email')
                            <a href="mailto:{{ $contactInfo->value }}" class="text-decoration-none h5">{{ $contactInfo->value }}</a>
                        @elseif($contactInfo->type === 'phone')
                            <a href="tel:{{ $contactInfo->value }}" class="text-decoration-none h5">{{ $contactInfo->value }}</a>
                        @elseif($contactInfo->type === 'social' && filter_var($contactInfo->value, FILTER_VALIDATE_URL))
                            <a href="{{ $contactInfo->value }}" target="_blank" class="text-decoration-none h5">{{ $contactInfo->value }}</a>
                        @else
                            <p class="h5 mb-0">{!! nl2br(e($contactInfo->value)) !!}</p>
                        @endif
                    </div>
                </div>

                <div class="mb-3">
                    <h5>Status</h5>
                    @if($contactInfo->is_active)
                        <span class="badge bg-success fs-6">Active - Visible on website</span>
                    @else
                        <span class="badge bg-danger fs-6">Inactive - Hidden from website</span>
                    @endif
                </div>

                <div class="mb-3">
                    <h5>Display Order</h5>
                    <p class="text-muted">Sort Order: {{ $contactInfo->sort_order ?? 0 }}</p>
                </div>

                @if($contactInfo->icon)
                    <div class="mb-3">
                        <h5>Icon</h5>
                        <div class="d-flex align-items-center">
                            <i class="{{ $contactInfo->icon }} fa-2x text-primary me-3"></i>
                            <code>{{ $contactInfo->icon }}</code>
                        </div>
                    </div>
                @endif
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Contact Information</h5>
            </div>
            <div class="card-body">
                <dl class="row">
                    <dt class="col-sm-4">ID:</dt>
                    <dd class="col-sm-8">{{ $contactInfo->id }}</dd>
                    
                    <dt class="col-sm-4">Type:</dt>
                    <dd class="col-sm-8">
                        <span class="badge bg-info">{{ ucfirst($contactInfo->type) }}</span>
                    </dd>
                    
                    <dt class="col-sm-4">Created:</dt>
                    <dd class="col-sm-8">{{ $contactInfo->created_at->format('M j, Y') }}<br>
                        <small class="text-muted">{{ $contactInfo->created_at->format('g:i A') }}</small>
                    </dd>
                    
                    <dt class="col-sm-4">Updated:</dt>
                    <dd class="col-sm-8">{{ $contactInfo->updated_at->format('M j, Y') }}<br>
                        <small class="text-muted">{{ $contactInfo->updated_at->format('g:i A') }}</small>
                    </dd>
                    
                    <dt class="col-sm-4">Sort Order:</dt>
                    <dd class="col-sm-8">{{ $contactInfo->sort_order ?? 0 }}</dd>
                    
                    <dt class="col-sm-4">Icon:</dt>
                    <dd class="col-sm-8">
                        @if($contactInfo->icon)
                            <code>{{ $contactInfo->icon }}</code>
                        @else
                            <span class="text-muted">No icon</span>
                        @endif
                    </dd>
                </dl>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Quick Actions</h5>
            </div>
            <div class="card-body">
                <div class="d-grid gap-2">
                    <a href="{{ route('admin.contact-info.edit', $contactInfo) }}" class="btn btn-primary">
                        <i class="fas fa-edit"></i> Edit Contact Info
                    </a>
                    
                    @if($contactInfo->type === 'email')
                        <a href="mailto:{{ $contactInfo->value }}" class="btn btn-outline-primary">
                            <i class="fas fa-envelope"></i> Send Email
                        </a>
                    @elseif($contactInfo->type === 'phone')
                        <a href="tel:{{ $contactInfo->value }}" class="btn btn-outline-success">
                            <i class="fas fa-phone"></i> Call Number
                        </a>
                    @elseif($contactInfo->type === 'social' && filter_var($contactInfo->value, FILTER_VALIDATE_URL))
                        <a href="{{ $contactInfo->value }}" target="_blank" class="btn btn-outline-info">
                            <i class="fas fa-external-link-alt"></i> Visit Profile
                        </a>
                    @endif
                    
                    <a href="{{ route('home') }}#contact" target="_blank" class="btn btn-success">
                        <i class="fas fa-eye"></i> View on Website
                    </a>
                    
                    <hr>
                    
                    <form action="{{ route('admin.contact-info.destroy', $contactInfo) }}" method="POST" onsubmit="return confirm('Are you sure you want to delete this contact information? This action cannot be undone.')">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-danger w-100">
                            <i class="fas fa-trash"></i> Delete Contact Info
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Website Display</h5>
            </div>
            <div class="card-body">
                <p class="small text-muted mb-2">How this appears on your website:</p>
                <div class="border rounded p-3">
                    <div class="d-flex align-items-center">
                        @if($contactInfo->icon)
                            <i class="{{ $contactInfo->icon }} fa-lg text-primary me-3"></i>
                        @endif
                        <div>
                            <strong>{{ $contactInfo->label }}:</strong> {{ Str::limit($contactInfo->value, 30) }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
