@extends('layouts.admin')

@section('title', 'About Sections')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">About Sections</h1>
    <a href="{{ route('admin.about-sections.create') }}" class="btn btn-primary">
        <i class="fas fa-plus"></i> Add New About Section
    </a>
</div>

<div class="card">
    <div class="card-body">
        @if($aboutSections->count() > 0)
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Image</th>
                            <th>Title</th>
                            <th>Subtitle</th>
                            <th>Content Preview</th>
                            <th>Status</th>
                            <th>Sort Order</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($aboutSections as $section)
                            <tr>
                                <td>
                                    @if($section->image)
                                        @if(filter_var($section->image, FILTER_VALIDATE_URL))
                                            <img src="{{ $section->image }}" alt="{{ $section->title }}" class="img-thumbnail" style="max-width: 80px; max-height: 60px; object-fit: cover;">
                                        @else
                                            <img src="{{ asset('storage/' . $section->image) }}" alt="{{ $section->title }}" class="img-thumbnail" style="max-width: 80px; max-height: 60px; object-fit: cover;">
                                        @endif
                                    @else
                                        <div class="bg-light d-flex align-items-center justify-content-center" style="width: 80px; height: 60px;">
                                            <i class="fas fa-user text-muted"></i>
                                        </div>
                                    @endif
                                </td>
                                <td>
                                    <strong>{{ $section->title }}</strong>
                                </td>
                                <td>
                                    @if($section->subtitle)
                                        <small class="text-muted">{{ Str::limit($section->subtitle, 30) }}</small>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    <small class="text-muted">{{ Str::limit($section->content, 50) }}</small>
                                </td>
                                <td>
                                    @if($section->is_active)
                                        <span class="badge bg-success">Active</span>
                                    @else
                                        <span class="badge bg-danger">Inactive</span>
                                    @endif
                                </td>
                                <td>{{ $section->sort_order ?? 0 }}</td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="{{ route('admin.about-sections.show', $section) }}" class="btn btn-outline-info" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('admin.about-sections.edit', $section) }}" class="btn btn-outline-primary" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('admin.about-sections.destroy', $section) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this about section?')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-outline-danger" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="text-center text-muted py-5">
                <i class="fas fa-user fa-3x mb-3"></i>
                <p class="h5">No about sections found</p>
                <p>Start by creating your first about section to tell your story.</p>
                <a href="{{ route('admin.about-sections.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Create First About Section
                </a>
            </div>
        @endif
    </div>
</div>

@if($aboutSections->count() > 0)
    <div class="mt-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">About Section Statistics</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-primary">{{ $aboutSections->count() }}</h4>
                            <small class="text-muted">Total Sections</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-success">{{ $aboutSections->where('is_active', true)->count() }}</h4>
                            <small class="text-muted">Active Sections</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-info">{{ $aboutSections->whereNotNull('image')->count() }}</h4>
                            <small class="text-muted">With Images</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-warning">{{ $aboutSections->whereNotNull('subtitle')->count() }}</h4>
                            <small class="text-muted">With Subtitles</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif
@endsection
