<?php $__env->startSection('title', ($siteSettings['about_title'] ?? 'About Me') . ' - ' . ($siteSettings['site_title'] ?? 'My Portfolio')); ?>

<?php $__env->startSection('content'); ?>
<!-- Modern About Banner -->
<div class="w3-display-container modern-banner" style="min-height:100vh">
    <?php if(isset($banners['about']) && $banners['about']): ?>
        <div class="w3-display-container" style="background-image: url('<?php echo e($banners['about']->background_image); ?>'); background-size: cover; background-position: center; min-height: 100vh;">
            <div class="banner-floating-elements">
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
            </div>
            <div class="w3-display-middle banner-content">
                <h1 class="banner-title"><?php echo e($banners['about']->overlay_text ?? $banners['about']->title); ?></h1>
                <?php if($banners['about']->subtitle): ?>
                    <p class="banner-subtitle"><?php echo e($banners['about']->subtitle); ?></p>
                <?php endif; ?>
                <p class="banner-description"><?php echo e($siteSettings['hero_description'] ?? 'Creating exceptional digital experiences through innovative design and cutting-edge technology'); ?></p>
                <div class="banner-buttons">
                    <?php if($banners['about']->button_text && $banners['about']->button_url): ?>
                        <a href="<?php echo e($banners['about']->button_url); ?>" class="banner-btn primary">
                            <i class="fa fa-rocket"></i>
                            <?php echo e($banners['about']->button_text); ?>

                        </a>
                    <?php else: ?>
                        <a href="#skills" class="banner-btn primary">
                            <i class="fa fa-cogs"></i>
                            View Skills
                        </a>
                    <?php endif; ?>
                    <a href="<?php echo e(route('contact')); ?>" class="banner-btn secondary">
                        <i class="fa fa-envelope"></i>
                        Get In Touch
                    </a>
                </div>
            </div>
        </div>
    <?php else: ?>
        <div class="bgimg-1 w3-display-container">
            <div class="banner-floating-elements">
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
                <div class="floating-shape"></div>
            </div>
            <div class="w3-display-middle banner-content">
                <h1 class="banner-title"><?php echo e($siteSettings['about_title'] ?? 'ABOUT ME'); ?></h1>
                <?php if($siteSettings['about_subtitle']): ?>
                    <p class="banner-subtitle"><?php echo e($siteSettings['about_subtitle']); ?></p>
                <?php endif; ?>
                <p class="banner-description"><?php echo e($siteSettings['hero_description'] ?? 'Creating exceptional digital experiences through innovative design and cutting-edge technology'); ?></p>
                <div class="banner-buttons">
                    <a href="#skills" class="banner-btn primary">
                        <i class="fa fa-cogs"></i>
                        View Skills
                    </a>
                    <a href="<?php echo e(route('contact')); ?>" class="banner-btn secondary">
                        <i class="fa fa-envelope"></i>
                        Get In Touch
                    </a>
                </div>
            </div>
        </div>
    <?php endif; ?>
</div>

<!-- Modern About Content -->
<section class="modern-about-section">
    <div class="w3-container w3-padding-64">
        <div class="w3-content">
            <?php if($aboutSections->count() > 0): ?>
                <!-- About Content Grid -->
                <div class="modern-about-content">
                    <?php $__currentLoopData = $aboutSections; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $section): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="modern-about-card" data-aos="fade-up" data-aos-delay="<?php echo e($index * 200); ?>">
                            <?php if($section->image): ?>
                                <div class="about-card-layout <?php echo e($index % 2 == 0 ? 'image-left' : 'image-right'); ?>">
                                    <!-- Image Section -->
                                    <div class="about-image-wrapper">
                                        <div class="about-image-container">
                                            <?php if(filter_var($section->image, FILTER_VALIDATE_URL)): ?>
                                                <img src="<?php echo e($section->image); ?>" alt="<?php echo e($section->title); ?>" class="about-image">
                                            <?php else: ?>
                                                <img src="<?php echo e(asset('storage/' . $section->image)); ?>" alt="<?php echo e($section->title); ?>" class="about-image">
                                            <?php endif; ?>
                                            <div class="about-image-overlay">
                                                <div class="about-image-decoration"></div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <!-- Content Section -->
                                    <div class="about-content-wrapper">
                                        <div class="about-content-inner">
                                            <div class="about-content-badge"><?php echo e(sprintf('%02d', $index + 1)); ?></div>
                                            <h3 class="about-content-title"><?php echo e($section->title); ?></h3>
                                            <?php if($section->subtitle): ?>
                                                <p class="about-content-subtitle"><?php echo e($section->subtitle); ?></p>
                                            <?php endif; ?>
                                            <div class="about-content-text">
                                                <p><?php echo nl2br(e($section->content)); ?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php else: ?>
                                <!-- Full Width Content Card -->
                                <div class="about-full-width-card">
                                    <div class="about-content-badge"><?php echo e(sprintf('%02d', $index + 1)); ?></div>
                                    <h3 class="about-content-title"><?php echo e($section->title); ?></h3>
                                    <?php if($section->subtitle): ?>
                                        <p class="about-content-subtitle"><?php echo e($section->subtitle); ?></p>
                                    <?php endif; ?>
                                    <div class="about-content-text">
                                        <p><?php echo nl2br(e($section->content)); ?></p>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            <?php else: ?>
                <!-- Default About Content -->
                <div class="modern-about-content">
                    <div class="modern-about-card" data-aos="fade-up">
                        <div class="about-full-width-card">
                            <div class="about-content-badge">01</div>
                            <h3 class="about-content-title">About Me</h3>
                            <p class="about-content-subtitle">Creative Professional & Digital Innovator</p>
                            <div class="about-content-text">
                                <p>Welcome to my portfolio! I am a passionate creative professional dedicated to delivering exceptional work and meaningful experiences. With years of experience in the industry, I specialize in creating innovative solutions that combine aesthetic appeal with functional excellence.</p>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <!-- Background Elements -->
    <div class="about-bg-elements">
        <div class="about-bg-shape about-bg-shape-1"></div>
        <div class="about-bg-shape about-bg-shape-2"></div>
        <div class="about-bg-pattern"></div>
    </div>
</section>

<!-- Modern Skills & Profile Section -->
<?php if($skills->count() > 0): ?>
    <section class="modern-skills-section">
        <div class="w3-container w3-padding-64">
            <div class="w3-content">
                <div class="skills-layout">
                    <!-- Profile Card -->
                    <div class="modern-profile-card" data-aos="fade-right">
                        <div class="profile-image-wrapper">
                            <?php if(filter_var($siteSettings['profile_image'] ?? '', FILTER_VALIDATE_URL)): ?>
                                <img src="<?php echo e($siteSettings['profile_image']); ?>" alt="Profile Photo" class="profile-image">
                            <?php else: ?>
                                <img src="https://www.w3schools.com/w3images/avatar_hat.jpg" alt="Profile Photo" class="profile-image">
                            <?php endif; ?>
                            <div class="profile-image-border"></div>
                        </div>
                        <div class="profile-info">
                            <h3 class="profile-name"><?php echo e($siteSettings['profile_name'] ?? 'Professional Name'); ?></h3>
                            <p class="profile-title"><?php echo e($siteSettings['profile_job_title'] ?? 'Creative Professional'); ?></p>
                            <p class="profile-description"><?php echo e($siteSettings['skills_intro'] ?? 'I have developed expertise in various areas through years of dedicated practice and continuous learning.'); ?></p>
                        </div>
                    </div>
                    
                    <!-- Skills Card -->
                    <div class="modern-skills-card" data-aos="fade-left">
                        <h3 class="skills-title"><?php echo e($siteSettings['skills_title'] ?? 'Core Expertise'); ?></h3>
                        <p class="skills-subtitle"><?php echo e($siteSettings['skills_description'] ?? 'My key areas of specialization'); ?></p>
                        
                        <div class="skills-grid">
                            <?php $__currentLoopData = $skills; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $skill): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="modern-skill-item">
                                    <div class="skill-header">
                                        <span class="skill-name"><?php echo e($skill->name); ?></span>
                                        <span class="skill-percentage"><?php echo e($skill->percentage); ?>%</span>
                                    </div>
                                    <div class="skill-progress-wrapper">
                                        <div class="skill-progress-track"></div>
                                        <div class="skill-progress-bar" 
                                             data-percentage="<?php echo e($skill->percentage); ?>" 
                                             style="background: linear-gradient(90deg, <?php echo e($skill->color); ?>, <?php echo e($skill->color); ?>80);">
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php endif; ?>

<!-- Modern Statistics Section -->
<?php if($statistics->count() > 0): ?>
    <section class="modern-stats-section">
        <div class="w3-container w3-padding-64">
            <div class="w3-content">
                <!-- Section Header -->
                <div class="stats-header w3-center w3-margin-bottom">
                    <h2 class="stats-section-title"><?php echo e($siteSettings['stats_title'] ?? 'Achievements & Milestones'); ?></h2>
                    <p class="stats-section-subtitle"><?php echo e($siteSettings['stats_subtitle'] ?? 'Numbers that showcase our journey and success story'); ?></p>
                    <div class="stats-title-divider"></div>
                </div>

                <!-- Statistics Grid -->
                <div class="modern-stats-grid">
                    <?php $__currentLoopData = $statistics; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="modern-stat-card" data-aos="fade-up" data-aos-delay="<?php echo e($index * 100); ?>">
                            <div class="stat-card-inner">
                                <!-- Icon -->
                                <?php if($stat->icon): ?>
                                    <div class="stat-icon-wrapper">
                                        <div class="stat-icon-bg"></div>
                                        <i class="<?php echo e($stat->icon); ?> stat-icon" title="Icon: <?php echo e($stat->icon); ?>"></i>
                                    </div>
                                <?php else: ?>
                                    <div class="stat-icon-wrapper">
                                        <div class="stat-icon-bg"></div>
                                        <i class="fa fa-bar-chart stat-icon" title="Default Icon"></i>
                                    </div>
                                <?php endif; ?>
                                
                                <!-- Counter -->
                                <div class="stat-counter-wrapper">
                                    <span class="stat-counter" data-count="<?php echo e($stat->value); ?>">0</span>
                                    <span class="stat-suffix"><?php echo e($stat->suffix); ?></span>
                                </div>
                                
                                <!-- Label -->
                                <h4 class="stat-label"><?php echo e($stat->label); ?></h4>
                                
                                <!-- Progress Bar -->
                                <div class="stat-progress-bar">
                                    <div class="stat-progress-fill" data-percentage="<?php echo e(min(100, ($stat->value / max($statistics->max('value'), 1)) * 100)); ?>"></div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
        
        <!-- Background Elements -->
        <div class="stats-bg-elements">
            <div class="stats-bg-circle stats-bg-circle-1"></div>
            <div class="stats-bg-circle stats-bg-circle-2"></div>
            <div class="stats-bg-circle stats-bg-circle-3"></div>
        </div>
    </section>
<?php endif; ?>

<!-- Modern Contact Information Section -->
<?php if($contactInfo->count() > 0): ?>
    <section class="modern-contact-section">
        <div class="w3-container w3-padding-64">
            <div class="w3-content">
                <!-- Section Header -->
                <div class="contact-header w3-center w3-margin-bottom">
                    <h2 class="section-title"><?php echo e($siteSettings['contact_info_title'] ?? 'GET IN TOUCH'); ?></h2>
                    <p class="section-subtitle"><?php echo e($siteSettings['contact_info_subtitle'] ?? 'Feel free to reach out through any of these channels'); ?></p>
                    <div class="title-divider"></div>
                </div>

                <!-- Contact Cards Row -->
                <div class="contact-cards-row w3-margin-bottom">
                    <?php if($contactInfo->whereIn('type', ['address', 'phone', 'email', 'website'])->count() > 0): ?>
                        <?php
                            $contactTypes = $contactInfo->whereIn('type', ['address', 'phone', 'email', 'website'])->sortBy('sort_order');
                        ?>
                        <?php $__currentLoopData = $contactTypes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="modern-contact-card">
                                <div class="contact-card-icon">
                                    <i class="fa <?php echo e($contact->icon ?? 'fa-info'); ?>"></i>
                                </div>
                                <h4 class="contact-card-title"><?php echo e($contact->label); ?></h4>
                                <div class="contact-card-content">
                                    <div class="contact-info">
                                        <?php if($contact->type === 'email'): ?>
                                            <a href="mailto:<?php echo e($contact->value); ?>" class="contact-link"><?php echo e($contact->value); ?></a>
                                        <?php elseif($contact->type === 'phone'): ?>
                                            <a href="tel:<?php echo e($contact->value); ?>" class="contact-link"><?php echo e($contact->value); ?></a>
                                        <?php elseif($contact->type === 'website'): ?>
                                            <p><?php echo e($contact->value); ?></p>
                                        <?php else: ?>
                                            <p><?php echo nl2br(e($contact->value)); ?></p>
                                        <?php endif; ?>
                                    </div>
                                    <?php if(in_array($contact->type, ['email', 'phone', 'website'])): ?>
                                        <div class="contact-card-action">
                                            <?php if($contact->type === 'email'): ?>
                                                <a href="mailto:<?php echo e($contact->value); ?>" class="contact-action-btn">
                                                    <i class="fa fa-envelope"></i> Send Email
                                                </a>
                                            <?php elseif($contact->type === 'phone'): ?>
                                                <a href="tel:<?php echo e($contact->value); ?>" class="contact-action-btn">
                                                    <i class="fa fa-phone"></i> Call Now
                                                </a>
                                            <?php elseif($contact->type === 'website'): ?>
                                                <a href="<?php echo e($contact->value); ?>" target="_blank" class="contact-action-btn">
                                                    <i class="fa fa-globe"></i> Visit Website
                                                </a>
                                            <?php endif; ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php else: ?>
                        <!-- Default Contact Cards -->
                        <div class="modern-contact-card">
                            <div class="contact-card-icon">
                                <i class="fa fa-map-marker"></i>
                            </div>
                            <h4 class="contact-card-title">Visit Us</h4>
                            <div class="contact-card-content">
                                <div class="contact-info">
                                    <p>123 Business Street<br>Suite 100<br>City, State 12345</p>
                                </div>
                            </div>
                        </div>
                        <div class="modern-contact-card">
                            <div class="contact-card-icon">
                                <i class="fa fa-phone"></i>
                            </div>
                            <h4 class="contact-card-title">Call Us</h4>
                            <div class="contact-card-content">
                                <div class="contact-info">
                                    <a href="tel:+1234567890" class="contact-link">+1 (234) 567-890</a>
                                </div>
                                <div class="contact-card-action">
                                    <a href="tel:+1234567890" class="contact-action-btn">
                                        <i class="fa fa-phone"></i> Call Now
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="modern-contact-card">
                            <div class="contact-card-icon">
                                <i class="fa fa-envelope"></i>
                            </div>
                            <h4 class="contact-card-title">Email Us</h4>
                            <div class="contact-card-content">
                                <div class="contact-info">
                                    <a href="mailto:hello@example.com" class="contact-link">hello@example.com</a>
                                </div>
                                <div class="contact-card-action">
                                    <a href="mailto:hello@example.com" class="contact-action-btn">
                                        <i class="fa fa-envelope"></i> Send Email
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="modern-contact-card">
                            <div class="contact-card-icon">
                                <i class="fa fa-globe"></i>
                            </div>
                            <h4 class="contact-card-title">Website</h4>
                            <div class="contact-card-content">
                                <div class="contact-info">
                                    <a href="https://example.com" class="contact-link">www.example.com</a>
                                </div>
                                <div class="contact-card-action">
                                    <a href="https://example.com" target="_blank" class="contact-action-btn">
                                        <i class="fa fa-globe"></i> Visit Website
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
                
                <!-- Social Media Links -->
                <?php if($contactInfo->where('type', 'social')->count() > 0): ?>
                    <div class="social-connect-section w3-center">
                        <h3 class="social-title"><?php echo e($siteSettings['social_title'] ?? 'Connect With Me'); ?></h3>
                        <p class="social-subtitle"><?php echo e($siteSettings['social_description'] ?? 'Follow me on social media for updates and behind-the-scenes content'); ?></p>
                        <div class="modern-social-links">
                            <?php $__currentLoopData = $contactInfo->where('type', 'social'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $social): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php if($social->is_active && filter_var($social->value, FILTER_VALIDATE_URL)): ?>
                                    <a href="<?php echo e($social->value); ?>" target="_blank" class="modern-social-btn" title="<?php echo e($social->label); ?>">
                                        <i class="fa <?php echo e($social->icon ?? 'fa-share-alt'); ?>"></i>
                                        <span class="social-label"><?php echo e($social->label); ?></span>
                                    </a>
                                <?php endif; ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
<?php endif; ?>

<!-- Call to Action -->
<div class="w3-center w3-padding-64 w3-light-grey">
    <div class="w3-content">
        <h3><?php echo e($siteSettings['cta_title'] ?? 'Ready to Work Together?'); ?></h3>
        <p class="w3-large"><?php echo e($siteSettings['cta_description'] ?? 'Let\'s discuss your next project and bring your vision to life.'); ?></p>
        <div class="w3-margin-top">
            <a href="<?php echo e(route('home')); ?>#contact" class="w3-button w3-black w3-large w3-padding-large w3-hover-grey">
                <i class="fa fa-envelope w3-margin-right"></i>GET IN TOUCH
            </a>
            <a href="<?php echo e(route('portfolio.index')); ?>" class="w3-button w3-light-grey w3-large w3-padding-large w3-margin-left w3-hover-black">
                <i class="fa fa-th w3-margin-right"></i>VIEW MY WORK
            </a>
        </div>
    </div>
</div>

<!-- Back to Home -->
<div class="w3-center w3-padding-32">
    <a href="<?php echo e(route('home')); ?>" class="modern-view-all-btn">
        <span class="btn-text">
            <i class="fa fa-home"></i> Back to Home
        </span>
        <span class="btn-arrow">
            <i class="fa fa-arrow-left"></i>
        </span>
        <div class="btn-ripple"></div>
    </a>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.frontend', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /opt/lampp/htdocs/pinky/resources/views/frontend/about.blade.php ENDPATH**/ ?>