@extends('layouts.admin')

@section('title', 'Skills')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Skills</h1>
    <a href="{{ route('admin.skills.create') }}" class="btn btn-primary">
        <i class="fas fa-plus"></i> Add New Skill
    </a>
</div>

<div class="card">
    <div class="card-body">
        @if($skills->count() > 0)
            <div class="table-responsive">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Preview</th>
                            <th>Skill Name</th>
                            <th>Percentage</th>
                            <th>Color</th>
                            <th>Status</th>
                            <th>Sort Order</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($skills as $skill)
                            <tr>
                                <td>
                                    <div style="width: 100px; height: 20px; background: #f0f0f0; border-radius: 10px; overflow: hidden;">
                                        <div style="width: {{ $skill->percentage }}%; height: 100%; background: {{ $skill->color }}; border-radius: 10px; display: flex; align-items: center; justify-content: center;">
                                            <small class="text-white" style="font-size: 10px;">{{ $skill->percentage }}%</small>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <strong>{{ $skill->name }}</strong>
                                </td>
                                <td>
                                    <span class="badge bg-info">{{ $skill->percentage }}%</span>
                                </td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <div style="width: 20px; height: 20px; background: {{ $skill->color }}; border-radius: 3px; margin-right: 8px;"></div>
                                        <code>{{ $skill->color }}</code>
                                    </div>
                                </td>
                                <td>
                                    @if($skill->is_active)
                                        <span class="badge bg-success">Active</span>
                                    @else
                                        <span class="badge bg-danger">Inactive</span>
                                    @endif
                                </td>
                                <td>{{ $skill->sort_order ?? 0 }}</td>
                                <td>
                                    <div class="btn-group btn-group-sm" role="group">
                                        <a href="{{ route('admin.skills.show', $skill) }}" class="btn btn-outline-info" title="View">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('admin.skills.edit', $skill) }}" class="btn btn-outline-primary" title="Edit">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('admin.skills.destroy', $skill) }}" method="POST" class="d-inline" onsubmit="return confirm('Are you sure you want to delete this skill?')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-outline-danger" title="Delete">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @else
            <div class="text-center text-muted py-5">
                <i class="fas fa-star fa-3x mb-3"></i>
                <p class="h5">No skills found</p>
                <p>Start by adding your first skill to showcase your expertise.</p>
                <a href="{{ route('admin.skills.create') }}" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Add First Skill
                </a>
            </div>
        @endif
    </div>
</div>

@if($skills->count() > 0)
    <div class="mt-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Skills Overview</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-primary">{{ $skills->count() }}</h4>
                            <small class="text-muted">Total Skills</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-success">{{ $skills->where('is_active', true)->count() }}</h4>
                            <small class="text-muted">Active Skills</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-info">{{ $skills->avg('percentage') ? round($skills->avg('percentage')) : 0 }}%</h4>
                            <small class="text-muted">Average Level</small>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="text-center">
                            <h4 class="text-warning">{{ $skills->where('percentage', '>=', 90)->count() }}</h4>
                            <small class="text-muted">Expert Level (90%+)</small>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endif
@endsection
