@extends('layouts.admin')

@section('title', 'Create About Section')

@section('content')
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Create About Section</h1>
    <a href="{{ route('admin.about-sections.index') }}" class="btn btn-secondary">
        <i class="fas fa-arrow-left"></i> Back to About Sections
    </a>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card">
            <div class="card-body">
                <form action="{{ route('admin.about-sections.store') }}" method="POST">
                    @csrf
                    
                    <div class="mb-3">
                        <label for="title" class="form-label">Title <span class="text-danger">*</span></label>
                        <input type="text" class="form-control @error('title') is-invalid @enderror" 
                               id="title" name="title" value="{{ old('title') }}" required>
                        @error('title')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="subtitle" class="form-label">Subtitle</label>
                        <input type="text" class="form-control @error('subtitle') is-invalid @enderror" 
                               id="subtitle" name="subtitle" value="{{ old('subtitle') }}">
                        @error('subtitle')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Optional subtitle or tagline</div>
                    </div>

                    <div class="mb-3">
                        <label for="content" class="form-label">Content <span class="text-danger">*</span></label>
                        <textarea class="form-control @error('content') is-invalid @enderror" 
                                  id="content" name="content" rows="8" required>{{ old('content') }}</textarea>
                        @error('content')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Main content for this about section. You can use line breaks for paragraphs.</div>
                    </div>

                    <div class="mb-3">
                        <label for="image" class="form-label">Image URL</label>
                        <input type="url" class="form-control @error('image') is-invalid @enderror" 
                               id="image" name="image" value="{{ old('image') }}">
                        @error('image')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Optional image URL (e.g., https://example.com/image.jpg)</div>
                    </div>

                    <div class="mb-3">
                        <label for="sort_order" class="form-label">Sort Order</label>
                        <input type="number" class="form-control @error('sort_order') is-invalid @enderror" 
                               id="sort_order" name="sort_order" value="{{ old('sort_order', 0) }}">
                        @error('sort_order')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="form-text">Lower numbers appear first</div>
                    </div>

                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" value="1" {{ old('is_active', true) ? 'checked' : '' }}>
                            <label class="form-check-label" for="is_active">
                                Active (show on website)
                            </label>
                        </div>
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Create About Section
                        </button>
                        <a href="{{ route('admin.about-sections.index') }}" class="btn btn-secondary">Cancel</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <div class="col-md-4">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">Image Preview</h5>
            </div>
            <div class="card-body">
                <div id="image-preview" class="text-center">
                    <div class="bg-light d-flex align-items-center justify-content-center" style="height: 200px;">
                        <i class="fas fa-user fa-3x text-muted"></i>
                    </div>
                    <small class="text-muted">Enter an image URL above to see preview</small>
                </div>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Tips</h5>
            </div>
            <div class="card-body">
                <ul class="list-unstyled small">
                    <li><i class="fas fa-lightbulb text-warning"></i> Use multiple sections to tell your story</li>
                    <li><i class="fas fa-lightbulb text-warning"></i> Add images to make sections more engaging</li>
                    <li><i class="fas fa-lightbulb text-warning"></i> Use sort order to control the sequence</li>
                    <li><i class="fas fa-lightbulb text-warning"></i> Keep content concise and focused</li>
                </ul>
            </div>
        </div>

        <div class="card mt-3">
            <div class="card-header">
                <h5 class="card-title mb-0">Section Ideas</h5>
            </div>
            <div class="card-body">
                <ul class="list-unstyled small text-muted">
                    <li>• About Me / Introduction</li>
                    <li>• Professional Background</li>
                    <li>• Skills & Expertise</li>
                    <li>• Education & Experience</li>
                    <li>• Personal Interests</li>
                    <li>• Mission & Values</li>
                </ul>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
document.getElementById('image').addEventListener('input', function() {
    const imageUrl = this.value;
    const previewDiv = document.getElementById('image-preview');
    
    if (imageUrl && isValidUrl(imageUrl)) {
        previewDiv.innerHTML = `
            <img src="${imageUrl}" alt="Preview" class="img-fluid rounded" style="max-height: 200px;" 
                 onerror="this.parentElement.innerHTML='<div class=\\'bg-danger text-white p-3 rounded\\'>Invalid image URL</div>'">
        `;
    } else {
        previewDiv.innerHTML = `
            <div class="bg-light d-flex align-items-center justify-content-center" style="height: 200px;">
                <i class="fas fa-user fa-3x text-muted"></i>
            </div>
            <small class="text-muted">Enter an image URL above to see preview</small>
        `;
    }
});

function isValidUrl(string) {
    try {
        new URL(string);
        return true;
    } catch (_) {
        return false;
    }
}
</script>
@endsection
